% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR_tidy.R
\name{llm_fn}
\alias{llm_fn}
\title{Vectorised LLM transformer}
\usage{
llm_fn(x, prompt, .config, .system_prompt = NULL, ...)
}
\arguments{
\item{x}{A character vector **or** a data.frame/tibble.}

\item{prompt}{A glue template string.
*If* \code{x} is a data frame, use \code{{col}} placeholders;
*if* \code{x} is a vector, refer to the element as \code{{x}}.}

\item{.config}{An \link{llm_config} object.}

\item{.system_prompt}{Optional system message (character scalar).}

\item{...}{Passed unchanged to \link{call_llm_broadcast} (e.g.\ \code{tries},
\code{progress}, \code{verbose}).}
}
\value{
A character vector the same length as \code{x}.
  Failed calls yield \code{NA}.
}
\description{
Vectorised LLM transformer
}
\details{
Runs each prompt through `call_llm_broadcast()`, which forwards the
requests to `call_llm_par()`.  That core engine executes them **in
parallel** according to the current *future* plan.  For instant
multi-core use, call `setup_llm_parallel(workers = 4)` (or whatever
number you prefer) once per session; revert with `reset_llm_parallel()`.
}
\examples{
## --- Vector input ------------------------------------------------------
\dontrun{
cfg <- llm_config(
  provider = "openai",
  model    = "gpt-4.1-nano",
  api_key  =  Sys.getenv("OPENAI_API_KEY"),
  temperature = 0
)

words <- c("excellent", "awful", "average")

llm_fn(
  words,
  prompt   = "Classify sentiment of '{x}' as Positive, Negative, or Neutral.",
  .config  = cfg,
  .system_prompt = "Respond with ONE word only."
)

## --- Data-frame input inside a tidyverse pipeline ----------------------
library(dplyr)

reviews <- tibble::tibble(
  id     = 1:3,
  review = c("Great toaster!", "Burns bread.", "It's okay.")
)

reviews |>
  llm_mutate(
    sentiment,
    prompt  = "Classify the sentiment of this review: {review}",
    .config = cfg,
    .system_prompt = "Respond with Positive, Negative, or Neutral."
  )
}
}
\seealso{
setup_llm_parallel, reset_llm_parallel, call_llm_par
}
