#' @export

print.LFprediction<-function(x, ...)
{
  if(!is(x,"LFprediction"))
    stop("x not of class LFprediction")
  prdct<-x$LFprediction
  if(x$model.type=="Classification")
  {
    prop<-x$proportion_one

    if(length(x)==3)
    {
      cat("OOB Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
      cat("\n")
      cat("Proportion of OOB trees that predict 1")
      cat("\n")
      print.default(prop, quote=FALSE)
    }
    if(length(x)==4)
    {
      cat("Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
      cat("\n")
      cat("Proportion of trees that predict 1")
      cat("\n")
      print.default(prop, quote=FALSE)
    }
  }

  if(x$model.type=="Linear Regression")
  {
    if(length(x)==4)
    {
      cat("OOB Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
      cat("\n")
      cat("OOB mean squared error")
      cat("\n")
      print.default(x$OOBmse, quote=FALSE)
    }
    if(length(x)==3)
    {
      cat("Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
    }
  }
}

