% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_withdiff.R
\name{network_withdiff}
\alias{network_withdiff}
\title{Network Analysis with Differential Species}
\usage{
network_withdiff(network_obj, diff_frame, aes_col = NULL, tag_threshold = 5)
}
\arguments{
\item{network_obj}{Network analysis results generated from \code{\link{network_analysis}}}

\item{diff_frame}{Differential analysis results generated from \code{\link{indicator_analysis}} or \code{\link{Deseq_analysis}}.}

\item{aes_col}{A named vector of colors to be used to highlight differential taxon vertices}

\item{tag_threshold}{Numeric. A threshold for the minimum number of differential taxon to display.}
}
\value{
A list containing the configured igraph object, vertices coordinates, parameters, and tag statistics.
}
\description{
Meta network analysis integrating differential taxon into a network analysis
}
\examples{
\donttest{
{
  # Data preparation
  data("Two_group")
  set.seed(999)
  # Analysis
  network_results <- network_analysis(
    taxobj = Two_group,
    taxlevel = "Genus",
    n = 10,
    threshold = 0.8
  )
  indicator_results <- indicator_analysis(
    taxobj = Two_group,
    taxlevel = "Genus"
  )
  deseq_results <- Deseq_analysis(
    taxobj = Two_group,
    taxlevel = "Genus",
    cutoff = 1,
    control_name = "Control"
  )

  # Visualize
  network_diff_obj <- network_withdiff(
    network_obj = network_results,
    diff_frame = indicator_results
  )
  # Check contained tags for each model
  print(network_diff_obj$tag_statistics$sum_of_tags)
  # Check contained different tags for each model
  print(network_diff_obj$tag_statistics$detailed_tags)

  # Re-visualize
  network_visual_re(
    network_visual_obj = network_diff_obj,
    module_paint = TRUE,
    module_num = c(1, 4)
  )  # Show module with most Treatment indicators

  my_module_palette <- color_scheme(
    c("#83BA9E", "#F49128"),
    5
  )
  network_visual_re(
    network_visual_obj = network_diff_obj,
    module_paint = TRUE,
    module_num = c(1, 4, 6, 3, 8),
    module_palette = my_module_palette
  )  # Show module with most Treatment indicators

  # Available also for DESeq analysis results
  network_diff_obj <- network_withdiff(
    network_obj = network_results,
    diff_frame = deseq_results
  )

  # Parameter adjustment
  network_diff_obj <- network_withdiff(
    network_obj = network_results,
    diff_frame = indicator_results,
    tag_threshold = 20
  )  # The 'tag_threshold' set too high

  network_diff_obj <- network_withdiff(
    network_obj = network_results,
    diff_frame = indicator_results,
    tag_threshold = 10
  ) # Set lower
  # Check contained tags for each model
  print(network_diff_obj$tag_statistics$sum_of_tags)
  # Check contained different tags for each model
  print(network_diff_obj$tag_statistics$detailed_tags)

  network_diff_obj <- network_withdiff(
    network_obj = network_results,
    diff_frame = indicator_results,
    tag_threshold = 1
  )  # Set too low

  # Another example
  data("Three_group")
  network_results <- network_analysis(
    taxobj = Three_group,
    taxlevel = "Genus",
    n = 15,
    threshold = 0.9
  )
  indicator_results <- indicator_analysis(
    taxobj = Three_group,
    taxlevel = "Genus"
  )

  tag_color <- c(
    "CF" = "#F8766D",
    "CF_OF" = "#FFFF00",
    "OF" = "#00BA38",
    "OF_BF" = "#800080",
    "BF" = "#619CFF",
    "CF_BF" = "#00FFFF"
  )
  network_diff_obj <- network_withdiff(
    network_obj = network_results,
    diff_frame = indicator_results,
    aes_col = tag_color,
    tag_threshold = 10
  )

  # Re-visualize
  print(network_diff_obj$tag_statistics$detailed_tags)
  network_visual_re(
    network_visual_obj = network_diff_obj,
    module_paint = TRUE,
    module_num = c(8, 10, 11)
  )  # Show module with most BF indicators
  network_visual_re(
    network_visual_obj = network_diff_obj,
    module_paint = TRUE,
    module_num = c(1, 6, 8)
  )  # Show module with most BF and OF_BF indicators
}
}
}
