% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_Al2O3C_ITC.R
\name{analyse_Al2O3C_ITC}
\alias{analyse_Al2O3C_ITC}
\title{Al2O3 Irradiation Time Correction Analysis}
\usage{
analyse_Al2O3C_ITC(
  object,
  signal_integral = NULL,
  dose_points = c(2, 4, 8, 12, 16),
  recordType = c("OSL (UVVIS)"),
  method_control = NULL,
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} or \link{list} (\strong{required}):
results obtained from the measurement.
Alternatively a list of \linkS4class{RLum.Analysis} objects can be provided to allow an automatic analysis}

\item{signal_integral}{\link{numeric} (\emph{optional}):
signal integral, used for the signal and the background.
If nothing is provided the full range is used. Argument can be provided as \link{list}.}

\item{dose_points}{\link{numeric} (\emph{with default}):
vector with dose points, if dose points are repeated, only the general
pattern needs to be provided. Default values follow the suggestions
made by Kreutzer et al., 2018. Argument can be provided as \link{list}.}

\item{recordType}{\link{character} (\emph{with default}): input curve selection, which is passed to
function \link{get_RLum}. To deactivate the automatic selection set the argument to \code{NULL}}

\item{method_control}{\link{list} (\emph{optional}):
optional parameters to control the calculation.
See details for further explanations}

\item{verbose}{\link{logical} (\emph{with default}):
enable/disable output to the terminal.}

\item{plot}{\link{logical} (\emph{with default}):
enable/disable the plot output.}

\item{...}{further arguments that can be passed to the plot output}
}
\value{
Function returns results numerically and graphically:

-----------------------------------\cr
\verb{[ NUMERICAL OUTPUT ]}\cr
-----------------------------------\cr

\strong{\code{RLum.Results}}-object

\strong{slot:} \strong{\verb{@data}}

\tabular{lll}{
\strong{Element} \tab \strong{Type} \tab \strong{Description}\cr
\verb{$data} \tab \code{data.frame} \tab correction value and error \cr
\verb{$table} \tab \code{data.frame} \tab table used for plotting  \cr
\verb{$table_mean} \tab \code{data.frame} \tab table used for fitting \cr
\verb{$fit} \tab \code{lm} or \code{nls} \tab the fitting as returned by the function \link{fit_DoseResponseCurve}
}

\strong{slot:} \strong{\verb{@info}}

The original function call

------------------------\cr
\verb{[ PLOT OUTPUT ]}\cr
------------------------\cr
\itemize{
\item A dose response curve with the marked correction values
}
}
\description{
The function provides a very particular analysis to correct the irradiation
time while irradiating Al2O3:C chips in a luminescence reader.
}
\details{
Background: Due to their high dose sensitivity Al2O3:C chips are usually
irradiated for only a very short duration or under the closed beta-source
within a luminescence reader. However, due to its high dose sensitivity, during
the movement towards the beta-source, the pellet already receives and non-negligible
dose. Based on measurements following a protocol suggested by Kreutzer et al., 2018,
a dose response curve is constructed and the intersection (absolute value) with the time axis
is taken as real irradiation time.

\strong{\code{method_control}}

To keep the generic argument list as clear as possible, arguments to allow a
deeper control of the method are all preset with meaningful default parameters and can be
handled using the argument \code{method_control} only, e.g.,
\code{method_control = list(fit.method = "LIN")}. Supported arguments are:

\tabular{lll}{
\strong{ARGUMENT} \tab \strong{FUNCTION} \tab \strong{DESCRIPTION}\cr
\code{mode} \tab \code{fit_DoseResponseCurve} \tab as in \link{fit_DoseResponseCurve}; sets the mode used for fitting\cr
\code{fit.method} \tab \code{fit_DoseResponseCurve} \tab as in \link{fit_DoseResponseCurve}; sets the function applied for fitting\cr
}
}
\section{Function version}{
 0.1.1
}

\examples{

##load data
data(ExampleData.Al2O3C, envir = environment())

##run analysis
analyse_Al2O3C_ITC(data_ITC)

} 

\section{How to cite}{
Kreutzer, S., 2025. analyse_Al2O3C_ITC(): Al2O3 Irradiation Time Correction Analysis. Function version 0.1.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\references{
Kreutzer, S., Martin, L., Guérin, G., Tribolo, C., Selva, P., Mercier, N., 2018. Environmental Dose Rate
Determination Using a Passive Dosimeter: Techniques and Workflow for alpha-Al2O3:C Chips.
Geochronometria 45, 56-67. doi: 10.1515/geochr-2015-0086
}
\seealso{
\link{fit_DoseResponseCurve}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{datagen}
