% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arw_adjustment.R
\name{arw_adjustment}
\alias{arw_adjustment}
\title{Atkinson–Riani–Welsh (ARW) Adjusted Cutoff for Robust Mahalanobis Distances}
\usage{
arw_adjustment(x, m0, c0, alpha, pcrit)
}
\arguments{
\item{x}{A numeric matrix or data frame of observations (rows) by variables (columns), with at least 2 columns.}

\item{m0}{A numeric vector of initial location estimates (length equal to number of columns in \code{x}).}

\item{c0}{A numeric covariance matrix corresponding to \code{m0}.}

\item{alpha}{Numeric; significance level for the chi-square threshold. Defaults to 0.05 if not provided.}

\item{pcrit}{Numeric; minimal proportion for the adjusted cutoff. If not provided, it is computed as:
\eqn{(0.24 - 0.003p)/\sqrt{n}} if \eqn{p \leq 10}, or \eqn{(0.252 - 0.0018p)/\sqrt{n}} if \eqn{p > 10}.}
}
\value{
A list with the following components:
\code{m}, the updated location vector after excluding outliers;
\code{c}, the updated covariance matrix;
\code{cn}, the adjusted cutoff on Mahalanobis distances;
\code{w}, a logical vector indicating which observations have distance less than or equal to \code{cn}.
}
\description{
Implements the ARW procedure to compute an adjusted cutoff for squared Mahalanobis distances,
then re-estimates location and scatter excluding points beyond the cutoff.
}
