% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeasurementValueAsNumeric.R
\name{plotMeasurementValueAsNumeric}
\alias{plotMeasurementValueAsNumeric}
\title{Plot summariseMeasurementTiming results.}
\usage{
plotMeasurementValueAsNumeric(
  result,
  x = c("unit_concept_name"),
  facet = c("codelist_name", "concept_name"),
  colour = c("cdm_name", visOmopResults::strataColumns(result))
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Columns to use as horizontal axes. See options with
`visOmopResults::plotColumns(result)`.}

\item{facet}{Columns to facet by. See options with
`visOmopResults::plotColumns(result)`. Formula input is also allowed to
specify rows and columns.}

\item{colour}{Columns to color by. See options with
`visOmopResults::plotColumns(result)`.}
}
\value{
A ggplot.
}
\description{
Plot summariseMeasurementTiming results.
}
\examples{
\donttest{
library(MeasurementDiagnostics)
cdm <- mockMeasurementDiagnostics()
result <- summariseMeasurementUse(
              cdm = cdm,
              bySex = TRUE,
              codes = list("test_codelist" = c(3001467L, 45875977L)))
plotMeasurementValueAsNumeric(result)
CDMConnector::cdmDisconnect(cdm)
}
}
