% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearningBN.R
\name{MoTBFs_Learning}
\alias{MoTBFs_Learning}
\title{Learning hybrid BNs with MoTBFs}
\usage{
MoTBFs_Learning(
  graph,
  data,
  numIntervals,
  POTENTIAL_TYPE,
  maxParam = NULL,
  s = NULL,
  priorData = NULL
)
}
\arguments{
\item{graph}{A network of the class \code{"bn"}, \code{"graphNEL"} or \code{"network"}.}

\item{data}{An object of class \code{"data.frame"}; it can contain continuous and discrete variables.}

\item{numIntervals}{A positive integer indicating the maximum number of intervals 
for splitting the domain of the continuous parent variables.}

\item{POTENTIAL_TYPE}{A \code{"character"} string, either \emph{MOP} or \emph{MTE}, 
corresponding to the type of basis function.}

\item{maxParam}{A positive integer which indicates the maximum number of coefficients in the function. 
If specified, the output is the function which gets the best BIC with, at most, this number of parameters.
By default, it is set to \code{NULL}.}

\item{s}{A \code{"numeric"} value which specifies the expert confidence in the prior knowledge. 
This argument takes values on the interval \emph{[0, N]}, where \emph{N} is the sample size, and is used
to synchronize the support of the prior knowledge and the sample.
By default, it is \code{NULL}, and must be modified only if prior information is to be incorporated to the fits.}

\item{priorData}{An object of class \code{"data.frame"}, corresponding to the prior information.}
}
\value{
A list of lists. Each list contains two elements
\item{Child}{A \code{"charater"} string which contains the name of the child variable.}
\item{functions}{A list of three elements: the name of the parents; a \code{"numeric"} vector
indicating the interval of the parent; and the fitted function in this interval.}
}
\description{
Learn mixtures of truncated basis functions in a full hybrid network.
}
\details{
If the variable is discrete then it computes the probabilities and the size of each leaf. 
Children that have discrete parents have as many functions as configurations of the parents. 
Children that have continuous parents have as many functions as the number indicated in the 
argument \code{"numIntervals"} for each parent. Children that have mixed parents, combine both methods.
The BIC criterion is used to decide the number of splitting points of the parent domains and to choose
the number of basis functions used.
}
\examples{

## Dataset Ecoli
require(MoTBFs)
data(ecoli)
data <- ecoli[,-c(1)] ## remove variable sequence

## Directed acyclic graph
dag <- LearningHC(data)

## Learning BN
intervals <- 3
potential <- "MOP"
P1 <- MoTBFs_Learning(graph = dag, data = data, numIntervals = intervals, POTENTIAL_TYPE=potential,
maxParam = 5)
printBN(P1)

 ## Learning BN
intervals <- 4
potential <- "MTE"
P2 <- MoTBFs_Learning(graph = dag, data = data, numIntervals = intervals, POTENTIAL_TYPE=potential,
maxParam = 15)
printBN(P2)


}
\seealso{
\link{printBN} and \link{ecoli}
}
