% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_patients.R
\name{sim_patients}
\alias{sim_patients}
\title{Generator of NHS patients}
\usage{
sim_patients(n_rows = 10, start_date = NULL)
}
\arguments{
\item{n_rows}{Number of rows/patients to generate}

\item{start_date}{Start date (needed to generate patient ages)}
}
\value{
A data.frame representing an empty waiting list with the
following columns:

\describe{
\item{Referral}{Date. Referral date; all values are \code{NA}.}
\item{Removal}{Date. Removal date; all values are \code{NA}.}
\item{Withdrawal}{Date. Patient withdrawal date; all values are
\code{NA}}
\item{Priority}{Numeric. Waiting list priority level, from 1
(most urgent) to 4 (least urgent).}
\item{Target_wait}{Numeric. Target number of days the patient should
wait at the assigned priority level (e.g., 28 days for priority 2)}
\item{Name}{Character. Patient name in the format
\code{"Last, First"}.}
\item{Birth_date}{Date. Date of birth.}
\item{NHS_number}{Integer. Patient identifier, up to 100,000,000.}
\item{Specialty_code}{Character. One-letter code representing the
specialty of the procedure.}
\item{Specialty}{Character. Full name of the specialty associated with
the procedure.}
\item{OPCS}{Character. OPCS-4 code of the selected procedure.}
\item{Procedure}{Character. Name of the selected procedure.}
\item{Consultant}{Character. Consultant name in the format
\code{"Last, First"}.}
}
}
\description{
Generates simulated NHS patients
}
\examples{
sim_patients()
}
