% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAIA.r
\name{opiPresent_for_MAIA}
\alias{opiPresent_for_MAIA}
\title{Implementation of opiPresent for the MAIA machine.}
\arguments{
\item{stim}{A list of stimulus parameters (see Details).}

\item{nextStim}{Unused - included for compliance with OPI standard.}
}
\value{
A list containing:
\itemize{
\item \code{err} 0 all clear, >= 1 some error codes (eg cannot track, etc) (integer)
\item \code{seen} \code{FALSE} for not seen, \code{TRUE} for seen (button pressed in response window)
\item \code{time} Response time in ms (integer) since stimulus onset, -1 for not seen
\item \code{time_rec} Time since epoch when command was received at MAIA (integer ms)
\item \code{time_pres} Time since epoch that stimulus was presented (integer ms)
\item \code{num_track_events} Number of tracking events that occurred during presentation (integer)
\item \code{num_motor_fails} Number of times motor could not follow fixation movement during presentation (integer)
\item \code{pupil_diam} Pupil diameter in mm (float)
\item \code{loc_x} X location in image of presentation (pixels, integer)
\item \code{loc_y} Y location in image of presentation (pixels, integer)
}
}
\description{
This is for internal use only. Use \code{\link[=opiSetup]{opiSetup()}} with
these Arguments and you will get the Value back.
}
\details{
If the chosen OPI implementation is \code{MAIA}, then \code{nextStim}
is ignored. Note that the dB level is rounded to the nearest integer.

If tracking is on, then this will block until the tracking is obtained,
and the stimulus presented.

\code{stim} is a list containing some or all of the following elements:
\itemize{
\item \code{x}, x-coordinate in degrees (floating point) (range $[-30,30]$).
\item \code{y}, y-coordinate in degrees (floating point) (range $[-30,30]$).
\item \code{level} is luminance in cd/\eqn{\mbox{m}^2}{m^2}, and is rounded to the nearest
whole dB for display (range 0 to 50). 0dB is 10000aps.
\item \code{responseWindow} is in milliseconds (range 0 to 2680).
}

Stimulus duration is assumed to be 200ms, and size is assumed to be
Goldmann III (0.43 degrees diameter),  color is assumed to be white.
These cannot be changed.
}
\examples{
\dontrun{
  # Set up the MAIA
  chooseOpi("MAIA")
  result <- opiInitialize(ip = "192.168.1.7", port = 44965)
  if (!is.null(result$err))
    stop("Initialisation failed")

   #' @param x X location of stim in degrees
   #' @param y Y location of stim in degrees
   #' @param size If 3, Goldmann III, else V
   #' @param db Value in dB
   #' @return stim object ready for opiPresent
   makeStim <- function(x, y, size, db) {
       s <- list(x = x, y = y, level = dbTocd(db, 10000 / pi),
           size = ifelse(size == 3, 0.43, 1.77),
           duration = 200, responseWindow = 1500)
       class(s) <- "opiStaticStimulus"
       return(s)
   }

   result <- opiPresent(makeStim(9, 9, 3, 10))
}

}
