% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Conf}
\alias{plot.Conf}
\title{Base Classifier Performance Heatmap}
\usage{
\method{plot}{Conf}(
  x = NULL,
  classNames = NULL,
  onlySens = FALSE,
  symmetric = FALSE,
  main = "summary of base classifiers",
  xlab = "classes",
  ylab = "base classifiers",
  digits = 3,
  ignore = 0,
  first.colors = c("#f5f5f5", "#b2182b"),
  second.colors = c("#f5f5f5", "#2166ac"),
  other.colors = c("#f5f5f5", "#1b7837"),
  na.color = c("yellow"),
  las = 1,
  srt = 30,
  color.key = FALSE,
  cex = 1,
  cex.lab = 1,
  ...
)
}
\arguments{
\item{x}{A Conf object as it is returned by \code{\link{conf}}-function.}

\item{classNames}{Vector of the original class names. If not given the class number is used instead.}

\item{onlySens}{A logical indicating if the plot should should be restricted to the class-wise sensitivities of the base classifiers.}

\item{symmetric}{Logical indicating whether a symmetric base classifier (TRUE) is used. Only used when onlySens is TRUE.}

\item{main}{See \code{\link{plot}}.}

\item{xlab}{A title for the x axis (see \code{\link{plot}}).}

\item{ylab}{A title for the y axis (see \code{\link{plot}}).}

\item{digits}{Integer indicating the number of decimal places to be used (see \code{\link{round}}).}

\item{ignore}{A numeric value between 0 and 1. 
All confusion and purity values below this number are not written as string into the corresponding element.}

\item{first.colors}{A 2-element vector of the color for the minimal and maximal class-wise sensitivity of the first class.
The color palette is calcuated by an interpolation between the 2 given colors.}

\item{second.colors}{A 2-element vector of the color for the minimal and maximal class-wise sensitivity of the second class.
The color palette is calcuated by an interpolation between the 2 given colors.}

\item{other.colors}{A 2-element vector of the color for the minimal and maximal class-wise sensitivity of the other class.
The color palette is calcuated by an interpolation between the 2 given colors.}

\item{na.color}{Color, which is used for indicating the empty elements (if the given class is not part of the cascade).}

\item{las}{See \code{\link{par}}.}

\item{srt}{Angle used to rotate the strings of the x-axis and y-axis labels (see \code{\link{par}}).}

\item{color.key}{Specifies whether a color key is drawn (TRUE) or not (FALSE).}

\item{cex}{See \code{\link{par}}.}

\item{cex.lab}{See \code{\link{par}}.}

\item{...}{Further arguments passed from other methods.}
}
\value{
No return value, called to generate the heatmap plot.
}
\description{
Plots a heatmap that shows base classifier performance.
}
\details{
This function plots a heatmap of the base classifier performance.
}
\examples{
library(TunePareto)
data(esl)
data <- esl$data
labels <- esl$labels
foldList <- generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap <- predictionMap(data, labels, foldList = foldList, 
                        classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
conf <- conf(predMap)

plot(conf, onlySens=TRUE, symmetric=TRUE)
}
\seealso{
\code{\link{conf}}, \code{\link{plot.Subcascades}}, \code{\link{plot.ConfusionTable}}
}
