% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\name{buildPathwaySpace}
\alias{buildPathwaySpace}
\title{Constructor of PathwaySpace-class Objects}
\usage{
buildPathwaySpace(
  gs,
  nrc = 500,
  verbose = TRUE,
  g = deprecated(),
  mar = deprecated()
)
}
\arguments{
\item{gs}{A \code{\link[RGraphSpace]{GraphSpace}} object. Alternatively, 
an \code{\link[igraph]{igraph}} object with node coordinates assigned 
to \code{x} and \code{y} vertex attributes, and node labels assigned 
to \code{name} vertex attribute.}

\item{nrc}{A single positive integer indicating the number of rows and 
columns (in pixels) for a square image matrix. This argument will 
affect the resulting image size and resolution.}

\item{verbose}{A single logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}

\item{g}{Deprecated from PathwaySpace 1.0.1; use 'gs' instead.}

\item{mar}{Deprecated from PathwaySpace 1.0.1; use 'mar' in
\code{\link[RGraphSpace]{GraphSpace}} instead.}
}
\value{
A pre-processed \linkS4class{PathwaySpace} class object.
}
\description{
\code{buildPathwaySpace} is a constructor of
PathwaySpace-class objects.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Check graph validity
gs <- GraphSpace(gtoy1, mar = 0.1)

# Create a new PathwaySpace object
ps <- buildPathwaySpace(gs, nrc = 100)
# note: adjust 'nrc' to increase image resolution

}
\seealso{
\code{\link[igraph]{undirected_graph}}
}
\author{
Victor Apolonio, Vinicius Chagas, Mauro Castro,
and TCGA Network.
}
