% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{align_to_timeframe}
\alias{align_to_timeframe}
\title{Align Data to Strategy Timeframe}
\usage{
align_to_timeframe(
  high_freq_data,
  low_freq_dates,
  method = c("forward_fill", "nearest", "interpolate")
)
}
\arguments{
\item{high_freq_data}{Data frame to align}

\item{low_freq_dates}{Date vector from strategy}

\item{method}{Alignment method: "forward_fill", "nearest", or "interpolate"}
}
\value{
Aligned data frame
}
\description{
Aligns higher-frequency data to match strategy timeframe.
}
\examples{
data("sample_prices_weekly")
data("sample_prices_daily")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, 10)
# Create a stability signal from daily data
daily_vol <- calc_rolling_volatility(sample_prices_daily, lookback = 20)
stability_signal <- align_to_timeframe(daily_vol, sample_prices_weekly$Date)
weights <- weight_by_signal(selected, stability_signal)
}
