% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{run_method}
\alias{run_method}
\title{Generic method function for publication bias correction}
\usage{
run_method(method_name, data, settings = NULL, silent = FALSE)
}
\arguments{
\item{method_name}{Character string specifying the method type}

\item{data}{Data frame containing yi (effect sizes) and sei (standard errors)}

\item{settings}{Either a character identifying a method version or list
containing method-specific settings. An emty input will result in running the
default (first implemented) version of the method.}

\item{silent}{Logical indicating whether error messages from the method should be suppressed.}
}
\value{
A data frame with standardized method results
}
\description{
This function provides a unified interface to various publication bias
correction methods. The specific method is determined by the first argument.
See
\href{../doc/Adding_New_Methods.html}{\code{vignette("Adding_New_Methods", package = "PublicationBiasBenchmark")}}
for details of extending the package with new methods
}
\section{Output Structure}{

The returned data frame follows a standardized schema that downstream
functions rely on. All methods return the following columns:
\itemize{
\item \code{method} (character): The name of the method used.
\item \code{estimate} (numeric): The meta-analytic effect size estimate.
\item \code{standard_error} (numeric): Standard error of the estimate.
\item \code{ci_lower} (numeric): Lower bound of the 95\% confidence interval.
\item \code{ci_upper} (numeric): Upper bound of the 95\% confidence interval.
\item \code{p_value} (numeric): P-value for the estimate.
\item \code{BF} (numeric): Bayes Factor for the estimate.
\item \code{convergence} (logical): Whether the method converged successfully.
\item \code{note} (character): Additional notes describing convergence issues.
}
Some methods may include additional method-specific columns beyond these
standard columns. Use \code{\link[=get_method_extra_columns]{get_method_extra_columns()}} to query which
additional columns a particular method returns.
}

\examples{
# Example usage with RMA method
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4),
  sei = c(0.1, 0.15, 0.08, 0.12)
)
result <- run_method("RMA", data, "default")
}
