% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{lung_cancer_survival_df}
\alias{lung_cancer_survival_df}
\title{Lung Cancer Survival Data}
\format{
A data frame with 228 observations (patients) and 10 variables:
\describe{
  \item{inst}{Institution code where patient was treated (numeric)}
  \item{time}{Survival time in days from diagnosis (numeric)}
  \item{status}{Censoring status (1 = censored, 2 = died) (numeric)}
  \item{age}{Patient age at diagnosis in years (numeric)}
  \item{sex}{Gender (1 = male, 2 = female) (numeric)}
  \item{ph.ecog}{ECOG performance score (0=asymptomatic to 4=fully disabled) (numeric)}
  \item{ph.karno}{Karnofsky performance score (0-100) as rated by physician (numeric)}
  \item{pat.karno}{Karnofsky performance score (0-100) as self-reported by patient (numeric)}
  \item{meal.cal}{Daily calories consumed at meals (numeric)}
  \item{wt.loss}{Weight loss in last six months (pounds) (numeric)}
}
}
\source{
Data taken from the acro package version 0.1.4
}
\usage{
data(lung_cancer_survival_df)
}
\description{
This dataset, lung_cancer_survival_df, is a data frame containing survival information
for 228 lung cancer patients, with 10 clinical variables including survival time,
patient status, age, gender, performance scores, and nutritional indicators.
}
\details{
The dataset name has been kept as 'lung_cancer_survival_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PulmoDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
