% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{control_heatmap}
\alias{control_heatmap}
\title{control_heatmap}
\usage{
control_heatmap(
  data,
  sel.Gene = "all",
  display.numbers = TRUE,
  dist.row = "euclidean",
  dist.col = "euclidean",
  clust.method = "average",
  colors = c("#4575B4", "#FFFFBF", "#C32B23"),
  show.colnames = TRUE,
  show.rownames = TRUE,
  border.color = NA,
  fontsize = 10,
  fontsize.col = 10,
  fontsize.row = 10,
  angle.col = 0,
  cellwidth = NA,
  cellheight = NA,
  show.legend = FALSE,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "heatmap_results"
)
}
\arguments{
\item{data}{Object returned from read_Ct_long() or read_Ct_wide() function,
or data frame containing at least column named "Sample" with sample names, column named "Gene" with gene names.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{display.numbers}{Logical: if TRUE (default), numeric values will be printed to the cells.}

\item{dist.row, dist.col}{Character: name of method used for calculation of distances between rows or columns, derived from stats::dist() function,
must be one of "euclidean" (default) , "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{clust.method}{Character: name of used method for agglomeration, derived from stats::hclust() function,
must be one of "ward.D", "ward.D2", "single", "complete", "average" (default), "mcquitty", "median" or "centroid".}

\item{colors}{Vector with colors used to fill created heatmap.}

\item{show.colnames, show.rownames}{Logical: of TRUE, names of columns (sample names) and rows (gene names) will be shown. Both default to TRUE.}

\item{border.color}{Character: color of cell borders on heatmap. If set to NA (default) no border will be drawn.}

\item{fontsize}{Numeric: global fontsize of heatmap. Default to 10.}

\item{fontsize.col, fontsize.row}{Numeric: fontsize of colnames and rownames. Default to 10.}

\item{angle.col}{Integer: angle of the column labels, one of the 0, 45, 90, 270, and 315.}

\item{cellwidth, cellheight}{Numeric: width and height of individual cell. Both default to NA.
These parameters are useful in situations where margins are too small and the plot is cropped (column names and annotation legend are sometimes partially hidden).
Specification of this parameter allows to adjust size of the plot and solve this problem.}

\item{show.legend}{Logical: if TRUE, legend will be shown. Default to FALSE.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "heatmap_results".}
}
\value{
Heatmap with hierarchical clustering, displayed on the graphic device (if save.to.tiff = FALSE)
or saved to .tiff file (if save.to.tiff = TRUE).
}
\description{
This function creates heatmap with number of replicates for each gene across samples.
}
\examples{
library(tidyverse)
library(pheatmap)
data(data.Ct)
# Vector of colors to fill the heatmap can be specified to fit the user needings:
colors <- c("#4575B4","#FFFFBF","#C32B23")
control_heatmap(data.Ct,
                sel.Gene = "all",
                colors = colors,
                show.colnames = TRUE,
                show.rownames = TRUE,
                fontsize = 11,
                fontsize.row = 11)

}
