% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.ext.R
\name{plotting.ext}
\alias{plotting.ext}
\title{Plot extrema in the response surface along the lines of congruence and incongruence}
\usage{
plotting.ext(
  RSA_object,
  model,
  acceleration = c(0, 0),
  n_sample = 100,
  names_xLOC = NULL,
  names_xLOIC = NULL,
  names_z = NULL,
  xlim = NULL,
  zlim = NULL,
  e_label = NULL,
  text_size = 1,
  elabel_size = 5,
  e_size = 3
)
}
\arguments{
\item{RSA_object}{An RSA object}

\item{model}{The model to be probed for extrema (reversal or acceleration points)}

\item{acceleration}{Rates of accelerations along the LOC and LOIC to be inspected (0< |rate| < 1). Passed on internally to \code{ident.ext}}

\item{n_sample}{Number of random draws to consider to find extrema. This option is used for large samples to increase speed in preliminary analyses, but it is not recommended for published results). Passed on internally to \code{ident.ext}}

\item{names_xLOC}{Label of x axis on the LOC plot.}

\item{names_xLOIC}{Label of x axis on the LOIC plot.}

\item{names_z}{Label of z axis (outcome).}

\item{xlim}{Limits of the x axis}

\item{zlim}{Limits of the z axis}

\item{e_label}{If "none", no coordinates are projected. Defaults to NULL.}

\item{text_size}{Text size for titles and labels.}

\item{elabel_size}{Text size for extrema coordinates.}

\item{e_size}{Point size of extrema.}
}
\value{
A list of plot of the lines of congruence (LOC) and incongruence (LOIC)
}
\description{
Plots the response surface of an RSA object along the lines of congruence (LOC) and incongruence (LOIC), while indicating the location of reversal or acceleration points in the surface (when they exist).
}
\details{
The lines of congruence (LOC) and incongruence (LOIC) are fundamental to RSA applications. This function allows plotting the response along the LOC and LOIC, thus offering a more precise visualization of the response surface (as a complement to 3d or 2d projections provided by \code{RSAplot}). The location of reversal or acceleration points can be provided with x-y-z coordinales or without them (e_label='none').
}
\examples{
######PLOT EXTREMA OVER LOC AND LOIC
EXTsim <- plotting.ext(RSA_step1,model="FM26_PARALLELASYMWEAK",
xlim=c(-3,3),zlim=c(-3,3),acceleration=c(0,-0.3),
text_size=0.7,elabel_size=3,e_size=2)
ggpubr::ggarrange(EXTsim[["LOC"]], EXTsim[["LOIC"]],
labels = c("A. Response over LOC", "B. Response over LOIC"),
nrow=1,ncol=2,font.label = list(size = 11))
}
\seealso{
\code{\link{RSAmodel}}
}
