% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zibeta.R
\name{zibeta}
\alias{zibeta}
\alias{dzibeta}
\alias{pzibeta}
\alias{rzibeta}
\title{Zero-inflated beta distribution}
\usage{
dzibeta(x, shape1, shape2, zeroprob = 0, log = FALSE)

pzibeta(q, shape1, shape2, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rzibeta(n, shape1, shape2, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape1, shape2}{non-negative shape parameters of the beta distribution}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dzibeta} gives the density, \code{pzibeta} gives the distribution function, and \code{rzibeta} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-inflated beta distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzibeta(1, 2, 2, 0.5)
d <- dzibeta(x, 2, 2, 0.5)
p <- pzibeta(x, 2, 2, 0.5)
}
