% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvc_from_custom_output.R
\name{rvn_rvc_from_custom_output}
\alias{rvn_rvc_from_custom_output}
\title{Generate RVC file from Custom Output CSVs}
\usage{
rvn_rvc_from_custom_output(filename, custfiles, FUN, init_date = NULL, ...)
}
\arguments{
\item{filename}{filepath of rvc file to be created (with .rvc extension)}

\item{custfiles}{array of filepaths to Raven Custom Output files (must be ByHRU)}

\item{FUN}{the aggregation function to be applied to state variables (e.g. mean, passed to sapply)}

\item{init_date}{datetime of model start (optional, can be calculated from Custom Output files)}

\item{...}{optional arguments passed to \code{\link{rvn_rvc_write}} (e.g. author, description)}
}
\value{
\item{TRUE}{if executed successfully}
}
\description{
Creates an initial conditions rvc file that specifies the initial state
using the information from the supplied custom output file.
}
\examples{
# Create array of custom output file(s)
custout <- c(system.file("extdata","run1_SNOW_Daily_Average_ByHRU.csv",package = "RavenR"))

# Create rvc file of mean snow for each HRU
rvn_rvc_from_custom_output(filename = file.path(tempdir(), "Blank.rvc"),
                           custfiles = custout,
                           FUN = mean)
}
\author{
Leland Scantlebury
}
