% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SUMO.R
\docType{package}
\name{SUMO}
\alias{SUMO-package}
\alias{SUMO}
\title{SUMO: Simulation Utilities for Multi-Omics Data}
\description{
It provides tools for simulating complex multi-omics datasets, enabling researchers to generate data that mirrors the biological intricacies observed in real-world omics studies. This package addresses a critical gap in current bioinformatics by offering flexible and customizable methods for synthetic multi-omics data generation, supporting method development, validation, and benchmarking.
}
\details{
\strong{Key Features:}
\itemize{
\item \strong{Multi-Omics Simulation}: Generate multi-layered datasets with shared and modality-specific structures.
\item \strong{Flexible Generation Engine}: Fine control over samples, noise levels, signal distributions, and latent factor structures.
\item \strong{Pipeline-Friendly Design}: Seamlessly integrates with existing multi-omics analysis workflows and packages (e.g., \code{SummarizedExperiment}, \code{MultiAssayExperiment}).
\item \strong{Visualization Tools}: Built-in plotting functions for exploring synthetic signals, factor structures, and noise.
}

\strong{Main Functions:}
\itemize{
\item \code{simulateMultiOmics()}: Simulates multiple (> two) high-dimensional multi-omics datasets.
\item \code{simulate_twoOmicsData()}: Simulates two high-dimensional multi-omics datasets.
\item \code{plot_simData()}: Visualizes generated data at different levels.
\item \code{plot_factor()}: Displays factor scores across samples for signal inspection.
\item \code{plot_weights()}: Visualizes feature loadings to assess signal versus noise.
\item \code{demo_multiomics_analysis()}: Full demo function for applying MOFA on SUMO-generated or real-world data.
\item \code{compute_means_vars()}: Estimate parameters from the real experimental dataset.
}
}
\author{
\strong{Maintainer}: Bernard Isekah Osang'ir \email{Bernard.Osangir@sckcen.be} (\href{https://orcid.org/0000-0002-5557-3602}{ORCID})

Other contributors:
\itemize{
  \item Ziv Shkedy [contributor]
  \item Surya Gupta [contributor]
  \item Jürgen Claesen [contributor]
}

}
\keyword{benchmarking}
\keyword{models}
\keyword{multi-omics}
