% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_pop.R
\name{sim_R}
\alias{sim_R}
\alias{sim_Z}
\alias{sim_N0}
\title{Simulate starting abundance, random recruitment and total mortality}
\usage{
sim_R(log_mean = log(3e+07), log_sd = 0.5, random_walk = TRUE, plot = FALSE)

sim_Z(
  log_mean = log(0.5),
  log_sd = 0.2,
  phi_age = 0.9,
  phi_year = 0.5,
  plot = FALSE
)

sim_N0(N0 = "exp", plot = FALSE)
}
\arguments{
\item{log_mean}{One mean value or a vector of means, in log scale, of length equal to years for \code{sim_R} or a matrix of means with
rows equaling the number of ages and columns equaling the number of years for \code{sim_Z}.}

\item{log_sd}{Standard deviation of the variable in the log scale.}

\item{random_walk}{Simulate recruitment as a random walk?}

\item{plot}{produce a simple plot of the simulated values?}

\item{phi_age}{Autoregressive parameter for the age dimension.}

\item{phi_year}{Autoregressive parameter for the year dimension.}

\item{N0}{Either specify "exp" or numeric vector of starting abundance excluding the first age.
If "exp" is specified using sim_N0, then abundance at age are calculated using exponential decay.}
}
\value{
Returns a function for use inside \code{\link{sim_abundance}}.
}
\description{
These functions return a function to use inside \code{\link{sim_abundance}}.
Given parameters, it generates N0, R and Z values.
}
\details{
sim_R generates uncorrelated recruitment values or random walk values from a log normal distribution.
sim_Z does the same as sim_R when phi_age and phi_year are both 0, otherwise values are correlated
in the age and/or year dimension. The covariance structure follows that described in Cadigan (2015).
}
\examples{

R_fun <- sim_R(log_mean = log(100000), log_sd = 0.1, random_walk = TRUE, plot = TRUE)
R_fun(years = 1:100)
sim_abundance(R = sim_R(log_mean = log(100000), log_sd = 0.5))
sim_abundance(years = 1:20,
              R = sim_R(log_mean = log(c(rep(100000, 10), rep(10000, 10))), plot = TRUE))

Z_fun <- sim_Z(log_mean = log(0.5), log_sd = 0.1, phi_age = 0.9, phi_year = 0.9, plot = TRUE)
Z_fun(years = 1:100, ages = 1:20)
sim_abundance(Z = sim_Z(log_mean = log(0.5), log_sd = 0.1, plot = TRUE))
Za_dev <- c(-0.2, -0.1, 0, 0.1, 0.2, 0.3, 0.3, 0.2, 0.1, 0)
Zy_dev <- c(-0.2, -0.2, -0.2, -0.2, -0.2, 2, 2, 2, 2, 0.2, 0.2, 0.2, 0.2, 0.2, 0, 0, 0, 0, 0, 0)
Z_mat <- outer(Za_dev, Zy_dev, "+") + 0.5
sim_abundance(ages = 1:10, years = 1:20,
              Z = sim_Z(log_mean = log(Z_mat), plot = TRUE))
sim_abundance(ages = 1:10, years = 1:20,
              Z = sim_Z(log_mean = log(Z_mat), log_sd = 0, phi_age = 0, phi_year = 0, plot = TRUE))

N0_fun <- sim_N0(N0 = "exp", plot = TRUE)
N0_fun(R0 = 1000, Z0 = rep(0.5, 20), ages = 1:20)
sim_abundance(N0 = sim_N0(N0 = "exp", plot = TRUE))

}
\references{
Cadigan, Noel G. 2015. A State-Space Stock Assessment Model for Northern Cod,
Including Under-Reported Catches and Variable Natural Mortality Rates. Canadian Journal of
Fisheries and Aquatic Sciences 73 (2): 296-308.
}
