% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc_get_data.R
\name{lc_nlcd}
\alias{lc_nlcd}
\title{Get NLCD Data}
\usage{
lc_nlcd(
  year = "2019",
  aoi = NULL,
  comid = NULL,
  showAreaSqKm = NULL,
  showPctFull = NULL,
  countOnly = NULL
)
}
\arguments{
\item{year}{Years(s) of NLCD metrics to query.
Only valid NLCD years are accepted (i.e. 2001, 2004, 2006, 2008,
2011, 2013, 2016, 2019)
Syntax: year=<year1>,<year2>}

\item{aoi}{Specify the area of interest described by a metric. By default, all available areas of interest
for a given metric are returned.
Syntax: areaOfInterest=<value1>,<value2>
Values: catchment|watershed|riparian_catchment|riparian_watershed|other}

\item{comid}{Return metric information for specific COMIDs
Syntax: comid=<comid1>,<comid2>}

\item{showAreaSqKm}{Return the area in square kilometers of a given area of interest.
The default value is false.
Values: true|false}

\item{showPctFull}{Return the pctfull for each dataset. The default value is false.
Values: true|false}

\item{countOnly}{Return a CSV containing only the row count (ROWCOUNT) and the column
count (COLUMNCOUNT) that the server expects to return in a request. The default value is false.
Values: true|false}
}
\value{
A tibble of desired StreamCat metrics
}
\description{
Function to specifically retrieve all NLCD metrics for a given year using the StreamCat API.
}
\examples{
\donttest{

df <- lc_nlcd(comid='23783629', year='2019', aoi='ws')

df <- lc_nlcd(year='2016', aoi='cat',
comid='23783629,23794487,23812618', showAreaSqKm=FALSE, showPctFull=TRUE)

df <- lc_nlcd(year='2016', aoi='cat',
comid='23783629,23794487,23812618', countOnly=TRUE)

df <- lc_nlcd(year='2016, 2019', aoi='cat,ws',
comid='23783629,23794487,23812618')
}
}
\author{
Marc Weber
}
