% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Superpower_options.R
\name{Superpower_options}
\alias{Superpower_options}
\title{Set/get global Superpower options}
\usage{
Superpower_options(...)
}
\arguments{
\item{...}{One of four: (1) nothing, then returns all options as a list; (2)
a name of an option element, then returns its' value; (3) a name-value pair
which sets the corresponding option to the new value (and returns nothing),
(4) a list with option-value pairs which sets all the corresponding
arguments. The example show all possible cases.}
}
\value{
depends on input, see above.
}
\description{
Global Superpower options are used, for example, by \code{\link{ANOVA_exact}} (et al.)
and \code{\link{ANOVA_power}}. But can be changed in each functions directly using
an argument (which has precedence over the global options).
}
\details{
The following arguments are currently set:
\itemize{
\item \code{verbose} should verbose (printed results) be set to true? Default is \code{TRUE}.
\item \code{emm} Option to perform analysis of estimated marginal means. Default is \code{FALSE}.
\item \code{emm_model} Model type ("multivariate", or "univariate") for estimated marginal means. Default is \code{"multivariate"}.
\item \code{contrast_type} The type of comparison for the estimated marginal means. Default is \code{"pairwise"}. See ?emmeans::'contrast-methods' for more details on acceptable methods.
\item \code{plot} Option to automatically print plots. Default is \code{FALSE}.
\item \code{alpha_level} Alpha level used to determine statistical significance. Default is .05.
\item \code{correction} Option to set a correction for sphericity violations. Default is no correction. This can be set to "none", "GG" Greenhouse-Geisser, and "HF" Huynh-Feldt
\item \code{liberal_lambda} Option to set a logical indicator of whether to use the liberal (cohen_f^2\*(num_df+den_df)) or conservative (cohen_f^2\*den_df) calculation of the noncentrality (lambda) parameter estimate. Default is FALSE.
}
}
\note{
All options are saved in the global R \code{\link{options}} with prefix
  \code{Superpower.}
}
