% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_check.R
\name{checkVars}
\alias{checkVars}
\title{Check Tow Formula Terms for Potential Problems.}
\usage{
checkVars(Data, term1, term2)
}
\arguments{
\item{Data}{(data.frame) containing all variables of
'term1' and 'term2'}

\item{term1}{(character) term of a model formula as
returned by 'attr(terms(form), \"term.labels\")')}

\item{term2}{(character) 2nd term of a model formula as
returned by 'attr(terms(form), \"term.labels\")')
to check against 'term1'}
}
\value{
(list) with components \"Diff\"=part of 'term2' distinguishing
			it from 'term1', \"AddInfo\"=message informing about potential
			problems with 'term2'
}
\description{
Is is checked whether 'term2' is different from 'term1'
in adding information to the model. If both are main
factors, i.e. no interactions terms, it is checked whether
levels of 'term2' differ from those of 'term1'. Otherwise,
'term2' is an interaction with a part being different from
'term1'.
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
