% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{add_item2}
\alias{add_item2}
\title{Define parameters that may be used in model calculations (uses expressions)}
\usage{
add_item2(.data = NULL, input)
}
\arguments{
\item{.data}{Existing data}

\item{input}{Items to define for the simulation as an expression (i.e., using {})}
}
\value{
A substituted expression to be evaluated by engine
}
\description{
Define parameters that may be used in model calculations (uses expressions)
}
\details{
The functions to add/modify events/inputs use lists. If chaining together add_item2, it will just append the expressions together in the order established.

If using \code{pick_val_v}, note it should be used with the \code{deploy_env = TRUE} argument so that add_item2 process it correctly.
}
\examples{
library(magrittr)

add_item2(input = {fl.idfs <-  0})
add_item2(input = {
 util_idfs <- if(psa_bool){rnorm(1,0.8,0.2)} else{0.8}
 util.mbc <- 0.6
 cost_idfs <- 2500})
common_inputs <- add_item2(input = {
pick_val_v(
  base      = l_statics[["base"]],
  psa       = pick_psa(
    l_statics[["function"]],
    l_statics[["n"]],
    l_statics[["a"]],
    l_statics[["b"]]
  ),
  sens      = l_statics[[sens_name_used]],
  psa_ind   = psa_bool,
  sens_ind  = sensitivity_bool,
  indicator = indicators_statics,
  names_out = l_statics[["parameter_name"]],
  deploy_env = TRUE #Note this option must be active if using it at add_item2
)
}
)

}
