% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_transform_longer.R
\name{acled_transform_longer}
\alias{acled_transform_longer}
\title{Transform ACLED data from wide to long}
\usage{
acled_transform_longer(data, type = "full_actors")
}
\arguments{
\item{data, }{dataframe or tibble containing your dataset.}

\item{type, }{character string. One of five types: full_actors, main_actors, assoc_actors, source, or all.
\itemize{
\item full_actors: All actor and associated actor columns
\item main_actors: Actor 1 and Actor 2 columns
\item assoc_actors: All associated actor columns
\item source: The source column becomes monadic
}}
}
\value{
A tibble with the data transformed into long form.
}
\description{
Function to convert your ACLED's API calls (if dyadic) into desired monadic forms.
}
\examples{
\dontrun{
# argen_acled <- acled_api(country = "Argentina",start_date = "2022-01-01",
#                          end_date="2022-02-01", acled_access = T, prompt = F)

# argen_acled_long_actors <- acled_transform_wide_to_long(argen_acled,
#                                            type = "full_actor") # Transforming the data

# nrow(argen_acled_long_actors) # Number of rows in the dataset
# [1] 263 # Long form

# nrow(argen_acled) ) # Number of rows in the dataset
# [1] 145 # Wide form
}
}
\seealso{
Other Data Manipulation: 
\code{\link{acled_transform_interaction}()},
\code{\link{acled_transform_wider}()}
}
\concept{Data Manipulation}
