% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_summarize_data.R
\name{amf_summarize_data}
\alias{amf_summarize_data}
\title{Get BASE data summary}
\usage{
amf_summarize_data(site_set = NULL, var_set = NULL)
}
\arguments{
\item{site_set}{A scalar or vector of character specifying the target
AmeriFlux Site ID (CC-Sss). If not specified, it returns all sites.}

\item{var_set}{A scalar or vector of character specifying the target
variables as in basename. See AmeriFlux
page\url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/#base}
for a list of variable names. If not specified, it returns all variables.}
}
\value{
A data frame of site-specific variable summary statistics (selected
percentiles) for selected AmeriFlux sites.
\itemize{
  \item Site_ID - Six character site identifier (CC-Sss)
  \item VARIABLE - Variable name of the data included in the BASE file
  \item BASENAME - Variable base name of the data included in the BASE file.
  \item GAP_FILLED - Whether a variable is a gap-filled variable (TRUE/FALSE)
  \item DATA_RECORD - Number of supposed data record (counts)
  \item DATA_MISSING - Number of missing data record (counts)
  \item Q01 - 1th percentile of the data
  \item Q05 - 5th percentile of the data
  \item ...
  \item Q95 - 95th percentile of the data
  \item Q99 - 99th percentile of the data
  }
}
\description{
This function obtains the BASE data summary for all or
selected AmeriFlux sites. See AmeriFlux page
\url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/} for details
about the variable naming.
}
\examples{
\dontrun{
# obtain the data variable availability for all sites & variables
data_sum <- amf_summarize_data()

# obtain the data variable availability for selected sites, all variables
data_sum <- amf_summarize_data(site_set = c("US-CRT","US-WPT"))

# obtain the data variable availability for selected sites & variables
data_sum <- amf_summarize_data(site_set = c("US-CRT","US-WPT"),
                               var_set = c("FC", "LE", "H"))
}
}
