% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-combine.R
\name{model_combine}
\alias{model_combine}
\title{Combine different (sub-)models}
\usage{
model_combine(...)
}
\arguments{
\item{...}{Phenology models, model names or lists with the keys \code{model} and
\code{submodels}. In the last case, only the submodels specified are used (one of
\code{'onset'}, \code{'diapause'}, \code{'mortality'} or \code{'development'}) of the respective
model. If multiple models are supplied for the same submodel, the last one
overwrites all others.}
}
\value{
A phenology model. Can be passed to \code{\link[=phenology]{phenology()}}.
}
\description{
Combine different (sub-)models.
}
\examples{
\donttest{
# combine PHENIPS with the diapause submodel of PHENIPS-Clim
m <- model_combine('phenips',
                   list(model = 'phenips-clim', submodels = 'diapause'))

# calculate phenology
p <- phenology(m, barrks_data(), .quiet = TRUE)

# plot calculated generations
gens <- get_generations_rst(p)
terra::plot(gens)
}


}
\seealso{
\itemize{
\item \code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}
\item Customize (sub-)models: \code{\link{model.bso.customize}}, \code{\link{model.phenips.customize}}, \code{\link{model.rity.customize}}, \code{\link{model.chapy.customize}}, \code{\link{model.joensson.customize}}, \code{\link{model.lange.customize}}, \code{\link{model.phenips_clim.customize}}
\item Use (sub-)models: \code{\link{model.bso.apply}}, \code{\link{model.phenips.apply}}, \code{\link{model.rity.apply}}, \code{\link{model.chapy.apply}}, \code{\link{model.joensson.apply}}, \code{\link{model.lange.apply}}, \code{\link{model.phenips_clim.apply}}
}
}
