% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bib.R
\name{read_bib}
\alias{read_bib}
\title{Read BibTeX Databases}
\usage{
read_bib(x, ...)
}
\arguments{
\item{x}{A single character value with the path to a BibTeX file.
Alternativelly it can be a character vector containing the lines of a
BibTeX library, for instance after using \code{\link[=readLines]{readLines()}}.}

\item{...}{Further arguments passed to \code{\link[=readLines]{readLines()}}.}
}
\value{
An object of class \linkS4class{lib_df}.
}
\description{
Reading BibTeX databases and importing into R as a data frame. All the fields
will be inserted as character values.
}
\examples{
Refs <- read_bib(x = file.path(
  path.package("biblio"),
  "LuebertPliscoff.bib"
))
Refs
}
