# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute number of models
#' 
#' Given a basket size and maximal number of distinct
#' response rates, compute the number of possible models
#' 
#' @param K positive integer giving number of baskets
#' @param P positive integer giving maximal number of distinct rates
#' 
#' @return integer giving number of possible models
#' @noRd
numModels_cpp <- function(K, P) {
    .Call('_bmabasket_numModels_cpp', PACKAGE = 'bmabasket', K, P)
}

#' Log posterior survival probability
#' 
#' Given a vector that gives a partition, computes the posterior probability 
#' that the basket proportion is larger than some specified value
#' 
#' @param pi0        vector whose elements are between 0 and 1 giving threshold for the hypothesis test. If a scalar is provided, assumes same threshold for each basket.
#' @param datMat     matrix of data. The first column gives the number of "successes" and second gives number of "failures" for each basket.
#' @param partition  vector giving a partition for a particular model
#' @param a0         beta prior shape parameter
#' @param b0         beta prior shape parameter
#' @param lbeta_a0b0 scalar giving \code{lbeta(a0, b0)}
#' 
#' @return list giving posterior probability, mean, and numerator for model probability for given model.
#' @noRd
logPostProb <- function(pi0, datMat, partition, a0, b0, lbeta_a0b0) {
    .Call('_bmabasket_logPostProb', PACKAGE = 'bmabasket', pi0, datMat, partition, a0, b0, lbeta_a0b0)
}

#' Bayesian model averaging (C++ function)
#'
#' Computes posterior model probabilities and Bayes model averaged survival function \math{P(\pi_k > pi0 | D)}
#'
#' @param pi0            vector whose elements are between 0 and 1 giving cutoffs for effect size for each basket
#' @param datMat         matrix of data \code{(y, n - y)}
#' @param partitionMat   martrix giving how to partition the data for each model
#' @param mu0            scalar giving prior mean for beta prior
#' @param phi0           scalar giving prior dispersion for beta prior
#' @param logModelPriors vector of length P giving the normalized priors for each model
#'
#' @return a list giving posterior probability and posterior mean
#' @keywords internal
#' @noRd
bma_cpp <- function(pi0, datMat, partitionMat, mu0, phi0, logModelPriors) {
    .Call('_bmabasket_bma_cpp', PACKAGE = 'bmabasket', pi0, datMat, partitionMat, mu0, phi0, logModelPriors)
}

#' Get collapsed data based on model
#'
#' Get the (collapsed) model data specified by a particular partition (model)
#'
#' @param yMat     matrix of \code{(y, n-y)} data
#' @param model  vector of indices giving how to partition the data
#' @return matrix giving partitioned data according to model
#'
#' @keywords internal
#' @noRd
collapseData <- function(yMat, model) {
    .Call('_bmabasket_collapseData', PACKAGE = 'bmabasket', yMat, model)
}

#' Simulate basket data
#'
#' Simulate data from basket trial based on specified parameters
#'
#' @param K0 integer giving number of baskets
#' @param I0 integer giving number of interim analyses
#' @param targSSPer  target sample size increment for each basket
#' @param rRates     \code{vector} of true response rates for each basket
#' @param eScales    \code{vector} giving reciprocal of poisson process rate for each basket
#' @param aParms     vector of length 2 giving normal mean and variance for time to outcome ascertainment
#' 
#' @return \code{matrix} giving simulated data from basket based on parameters
#' @details Each column of the returning matrix is as follows:
#' * y
#' * b
#' * et
#' * at
#' * ft
#'
#' @keywords internal
#' @noRd
simData <- function(K0, I0, targSSPer, rRates, eScales, aParms) {
    .Call('_bmabasket_simData', PACKAGE = 'bmabasket', K0, I0, targSSPer, rRates, eScales, aParms)
}

#' Simulate a BMA design
#'
#' Simulates a BMA design given hyperparameters
#'
#' @param nSims number of simulation studies to be performed
#' @param eRates \code{vector} of Poisson process rates for each basket
#' @param rRates \code{vector} of true response rates for each basket
#' @param aParms \code{vector} giving time to outcome ascertainment distribution parameters (common)
#' @param ppEffCrit \code{vector} giving basket-specific posterior probability threshold for activity (i.e., efficacy)
#' @param ppFutCrit \code{vector} giving basket-specific posterior probability threshold for futility
#' @param futOnly \code{logical} giving whether design allows only for futility stopping (\code{TRUE} = futility only, \code{FALSE} = both futility and efficacy)
#' @param rRatesNull \code{vector} of basket-specific null hypothesis values (for efficacy determination)
#' @param rRatesAlt \code{vector} of basket-specific hypothesized alternative values (for futility determination)
#' @param minSSFut minimum number of subjects in basket to assess futility
#' @param minSSEff minimum number of subjects in basket to assess activity
#' @param minSSEnr matrix giving minimum number of new subjects per basket before next analysis (each row is an interim analysis)
#' @param targSSPer vector giving target sample size increment for each basket
#' @param I0 maximum number of analyses
#' @param mu0 prior mean for the response probabilities
#' @param phi0 prior dispersion response probabilities
#' @param partitionMat matrix giving partitions
#' @param logModelPriors vector giving prior model probabilities
#' 
#' @return a list giving aspects of the simulation
#' @keywords internal
#' @noRd
bma_design_cpp <- function(nSims, eRates, rRates, aParms, ppEffCrit, ppFutCrit, futOnly, rRatesNull, rRatesAlt, minSSFut, minSSEff, minSSEnr, maxSSEnr, targSSPer, I0, mu0, phi0, models, logPriorModelProbs) {
    .Call('_bmabasket_bma_design_cpp', PACKAGE = 'bmabasket', nSims, eRates, rRates, aParms, ppEffCrit, ppFutCrit, futOnly, rRatesNull, rRatesAlt, minSSFut, minSSEff, minSSEnr, maxSSEnr, targSSPer, I0, mu0, phi0, models, logPriorModelProbs)
}

