% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restructure.R
\name{restructure.bmmfit}
\alias{restructure.bmmfit}
\alias{restructure}
\title{Restructure Old \code{bmmfit} Objects}
\usage{
\method{restructure}{bmmfit}(x, ...)
}
\arguments{
\item{x}{An object of class \code{bmmfit}.}

\item{...}{Currently ignored.}
}
\value{
A \code{bmmfit} object compatible with the latest version
of \pkg{bmm} and \pkg{brms}.
}
\description{
Restructure old \code{bmmfit} objects to work with
the latest \pkg{bmm} version. This function is called
internally when applying post-processing methods.
}
\examples{
\dontshow{if (file.exists("bmmfit_old.rds")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load an old bmmfit object
old_fit <- readRDS("bmmfit_old.rds")
new_fit <- restructure(old_fit)
\dontshow{\}) # examplesIf}
}
\keyword{transform}
