% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_bit.R
\name{bc.bit}
\alias{bc.bit}
\alias{bc.bit,ANY-method}
\title{Broadcasted Bit-wise Operations}
\usage{
bc.bit(x, y, op, ...)

\S4method{bc.bit}{ANY}(x, y, op)
}
\arguments{
\item{x, y}{conformable raw or integer (32 bit) vectors/arrays.}

\item{op}{a single string, giving the operator. \cr
Supported bit-wise operators: &, |, xor, nand, ==, !=, <, >, <=, >=, <<, >>.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
For bit-wise operators: \cr
An array of the same type as \code{x} and \code{y},
as a result of the broadcasted bit-wise operation. \cr
\cr
}
\description{
The \code{bc.bit()} function
performs broadcasted bit-wise operations
on pairs of arrays, where both arrays are of type \code{raw} or both arrays are of type \code{integer}. \cr
\cr
}
\details{
The "&", "|", "xor", and "nand" operators given in \code{bc.bit()}
perform BIT-WISE AND, OR, XOR, and NAND operations, respectively. \cr
\cr
The relational operators given in \code{bc.bit()} perform BIT-WISE relational operations:
\itemize{
\item "==" is equivalent to bit-wise \code{(x & y) | (!x & !y)}, but faster;
\item "!=" is equivalent to bit-wise \code{xor(x, y)};
\item "<" is equivalent to bit-wise \code{(!x & y)}, but faster;
\item ">" is equivalent to bit-wise \code{(x & !y)}, but faster;
\item "<=" is equivalent to bit-wise \code{(!x & y) | (y == x)}, but faster;
\item ">=" is equivalent to bit-wise \code{(x & !y) | (y == x)}, but faster. \cr \cr
}

The "<<" and ">>" operators perform bit-wise left-shift and right-shift,
respectively,
on \code{x} by unit \code{y}. \cr
For these shift operations,
\code{y} being larger than the number of bits of \code{x} results in an error. \cr
Shift operations are only supported for type of \code{raw}. \cr \cr
}
\examples{
x.dim <- c(4:2)
x.len <- prod(x.dim)
x.data <- as.raw(0:10)
y.data <- as.raw(10:0)
x <- array(x.data, x.dim)
y <- array(y.data, c(4,1,1))

bc.bit(x, y, "&")
bc.bit(x, y, "|")
bc.bit(x, y, "xor")

}
\seealso{
\link{broadcast_operators} \cr
}
