% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-git.R
\name{btw_tool_git_status}
\alias{btw_tool_git_status}
\title{Tool: Git Status}
\usage{
btw_tool_git_status(
  include = c("both", "staged", "unstaged"),
  pathspec = NULL,
  `_intent` = ""
)
}
\arguments{
\item{include}{One of \code{"both"}, \code{"staged"}, or \code{"unstaged"}. Use \code{"both"} to
show both staged and unstaged files (default).}

\item{pathspec}{Optional character vector with paths to match.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a character table of file statuses.
}
\description{
This tool allows the LLM to run \code{\link[gert:git_commit]{gert::git_status()}}, equivalent to \verb{git status} in the terminal, and to see the current status of the working
directory.
}
\examples{
\dontshow{if (rlang::is_installed("gert")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  gert::git_init()
  gert::git_config_set("user.name", "R Example")
  gert::git_config_set("user.email", "ex@example.com")

  writeLines("hello, world", "hello.md")

  # What the LLM sees
  cat(btw_tool_git_status()@value)
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other git tools: 
\code{\link{btw_tool_git_branch_checkout}()},
\code{\link{btw_tool_git_branch_create}()},
\code{\link{btw_tool_git_branch_list}()},
\code{\link{btw_tool_git_commit}()},
\code{\link{btw_tool_git_diff}()},
\code{\link{btw_tool_git_log}()}
}
\concept{git tools}
