% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_tabulate_abnormal.R
\name{ard_tabulate_abnormal}
\alias{ard_tabulate_abnormal}
\title{ARD Abnormality Counts}
\usage{
ard_tabulate_abnormal(
  data,
  postbaseline,
  baseline,
  id = NULL,
  by = NULL,
  strata = NULL,
  abnormal = list(Low = "LOW", High = "HIGH"),
  excl_baseline_abn = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{postbaseline}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name of post-baseline reference range indicator variable.}

\item{baseline}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name of baseline reference range indicator variable.}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name used to identify unique participants in \code{data}. If \code{NULL}, each row in \code{data} is assumed to correspond
to a unique participants.}

\item{by, strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to tabulate by/stratify by for summary statistic
calculation. Arguments are similar, but with an important distinction:

\code{by}: results are calculated for \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: results are calculated for \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}

\item{abnormal}{(\code{list})\cr
a named list of abnormalities to assess for. Each element should specify all levels of \code{postbaseline}/\code{baseline}
that should be included when assessing for a given abnormality, with the name specifying the name of the
abnormality. Any levels specified but not present in the data are ignored.}

\item{excl_baseline_abn}{(\code{logical})\cr
whether participants with baseline abnormality should be excluded from calculations. Defaults to \code{TRUE}.}

\item{quiet}{(scalar \code{logical})\cr
logical indicating whether to suppress additional messaging. Default is \code{FALSE}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Function counts participants with abnormal analysis range values.

For each abnormality specified via the \code{abnormal} parameter (e.g. Low or High), statistic \code{n} is
calculated as the number of patients with this abnormality recorded, and statistic \code{N} is calculated as
the total number of patients with at least one post-baseline assessment. \code{p} is calculated as
\code{n / N}. If \code{excl_baseline_abn=TRUE} then participants with abnormality at baseline are excluded
from all statistic calculations.
}
\examples{
# Load Data -------------------
set.seed(1)
adlb <- cards::ADLB
adlb$BNRIND <- ifelse(
  adlb$BNRIND != "N",
  sample(c("LOW", "LOW LOW", "HIGH", "HIGH HIGH"), nrow(adlb), replace = TRUE),
  "NORMAL"
)

# Example 1 -------------------
adlb |>
  ard_tabulate_abnormal(
    postbaseline = LBNRIND, baseline = BNRIND, id = USUBJID, by = TRTA,
    abnormal = list(Low = c("LOW", "LOW LOW"), High = c("HIGH", "HIGH HIGH"))
  )
}
