\name{dahgrid}
\alias{dahgrid}
\title{Interpolation of normalized homogeneous data on a predefined grid}
\description{
  Homogenized data generated by \code{\link{homogen}} are normalized and
  interpolated on a grid provided by the user at every time step, and saved
  into a NetCDF file.
}
\usage{
dahgrid(varcli, anyi, anyf, anyip=anyi, anyfp=anyf, grid, idp=2.0,
obsonly=TRUE, nmax=Inf)
}
\arguments{
  \item{varcli}{Short name of the studied climatic variable, as in the data
  file name.}
  \item{anyi}{Initial year of the homogenized data.}
  \item{anyf}{Final year of the homogenized data.}
  \item{anyip}{First year of the desired reference period. (The reference period defaults to the whole period of the data).}
  \item{anyfp}{Last year of the desired reference period.}
  \item{grid}{Grid on which interpolations must be performed.}
  \item{idp}{Power of the inverse distance weights (2 by default).}
  \item{obsonly}{Do not interpolate estimated missing data. (\code{TRUE} by
  default).}
  \item{nmax}{Maximum number of nearest stations to use (all by default).}
}
\details{
  Homogenized data are read from the binary file \file{VRB_ANYI-ANYF.rda}
  generated by \code{\link{homogen}}. Only series reconstructed from their
  longest homogeneous sub-period are retained, and they are normalized by their
  means (and standard deviations, if \code{std=3}), computed for the selected
  reference period (or for the whole period of the data, by default).

  Unless \code{obsonly} is set to \code{FALSE}, data that were missing in the
  observed series are deleted to avoid interpolation of already interpolated
  data.
  
  Finally, the normalized homogeneous data are interpolated on the predefined
  grid for every time step using an inverse distance weight method, and the
  resulting grids are stored in a NetCDF file named \file{VRB_ANYIP-ANYFP.nc},
  including grids of the reference means (and standard deviations, if applied).

  The user must provide the grid as an object of class SpatialPixel, as in this
  example defining a grid from 40N,3E to 43N,7E with a resolution of 0.1
  degrees:

  \code{grid <- expand.grid(x=seq(3,7,.1),y=seq(40,43,.1))}\cr
  \code{library(sp)}\cr
  \code{coordinates(grid) <- ~ x+y}

  The resolution of this grid need not be too high, but adjusted to the spatial
  density of the available series. However, a higher resolution will produce
  smoother maps when plotted.

  The user may be more interested in obtaining grids of absolute values, rather
  than normalized. This can be achieved simply by undoing the normalization on
  the grids with the help of the provided grids of reference means and standard
  deviations. However, the resulting grids will only be the product of a
  geometrical interpolation, and will not reflect the influence of orography
  and other physiographic effects on the studied climatic variable. Therefore,
  it is more advisable to derive better reference grids of means (and standard
  deviations, if needed) by applying a geostatistical model to the reference
  means (provided in the file \file{VRB_ANYIP-ANYFP_means.csv} with their
  corresponding coordinates).
  
  This better quality climatic maps will probably have a higher resolution than
  that of the grids of the NetCDF file provided by this function. In that case,
  these normalized grids must be interpolated to the grid of the
  geostatistically derived climatic maps before undoing the normalization to
  obtain the final maps of absolute values at all or selected time-steps of the
  studied period.
}
\seealso{\code{\link{homogen}}}
\examples{
## Set a temporal working directory and write input files:
wd <- tempdir()
wd0 <- setwd(wd)

## Copy an example file of homogenization results:
file.copy(exampleFiles('Temp_1991-2000.rda'),'.')

## Now run the example:
## (very coarse grid (3x2 points) to run in less than the 5 seconds CRAN limit)
grd <- expand.grid(x=seq(-2.8,-2.4,.2),y=seq(38.86,39.06,.2))
sp::coordinates(grd) <- ~ x+y
# (generate the grid for 1996-2000 only, again to run in less than 5 seconds)
dahgrid('Temp',1991,2000,1996,2000,grid=grd)

## Return to user's working directory:
setwd(wd0)

## Input and output files can be found in directory:
print(wd)
}
\keyword{datagen}

