% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{cminkowski}
\alias{cminkowski}
\title{Calculate the Minkowski distance of a factor in a dataframe.}
\usage{
cminkowski(
  dataset,
  formula,
  p = 3,
  plot = TRUE,
  plot_title = "Minkowski Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{The factor which you want to calculate the Minkowski distances matrix.}

\item{p}{Order of the Minkowski distance}

\item{plot}{If TRUE, shows a plot of the Minkowski distances matrix.}

\item{plot_title}{The title of the plot.}
}
\value{
The matrix containing distances.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Minkowski distances about it.
}
\details{
Calculate Minkowski distance
}
\examples{

# Example with iris dataset

cminkowski(iris, ~Species, p = 3, plot = TRUE, plot_title = "Minkowski Distance Between Groups")

# Example with mtcars dataset

cminkowski(mtcars, ~am, p = 3, plot = TRUE, plot_title = "Minkowski Distance Between Groups")

}
