% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMatrix.R
\name{MImat2mat}
\alias{MImat2mat}
\title{Normalized Mutual Information Between Two Matrices}
\usage{
MImat2mat(mat1, mat2, bin = 6, sp_order = 2)
}
\arguments{
\item{mat1}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{mat2}{Another numeric matrix to compare against. Must have the same dimensions as `mat1`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric vector where each element corresponds to the normalized mutual information (MI) between
respective rows of `mat1` and `mat2`.
}
\description{
Computes the normalized mutual information (MI) between corresponding rows of two matrices
normalized by their individual information content, using the specified number of bins and spline order.
}
\examples{
mat1 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
mat2 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
MImat2mat(mat1, mat2)

}
