% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cord.R
\name{cord}
\alias{cord}
\title{Community estimation in G-models via CORD}
\usage{
cord(X, tau = 2 * sqrt(log(ncol(X))/nrow(X)), kendall = T,
  input = c("data", "cor", "dist"))
}
\arguments{
\item{X}{Input data matrix. It should be an n (samples) by p (variables) matrix  when \code{input} is set to the value "data" by default. It can also be a p by p symmetric matrix when \code{X} is a correlation matrix or a distance matrix if \code{input} is set accordingly.}

\item{tau}{Threshold to use at each iteration. A theoretical choice is about \eqn{2n^{-1/2}\log^{1/2} p}.}

\item{kendall}{Whether to compute Kendall's tau correlation matrix from \code{X}, when \code{input} is set to "data". If \code{FALSE}, Pearson's correlation will be computed, usually faster for large p.}

\item{input}{Type of input \code{X}. It should be set to "data" when \code{X} is an  n (samples) by p (variables) matrix. If \code{X} is a correlation matrix or a distance matrix, it should be set to "cor" or "dist" respectively.}
}
\value{
\code{list} with one element: a vector of integers showing which cluster/community each point is assigned to.
}
\description{
Partition data points (variables) into clusters/communities. Reference: Bunea, F., Giraud, C., & Luo, X. (2015). Community estimation in \eqn{G}-models via CORD. arXiv preprint arXiv:1508.01939. \url{http://arxiv.org/abs/1508.01939}.
}
\examples{
set.seed(100)
X <- 2*matrix(rnorm(200*2), 200, 10)+matrix(rnorm(200*10), 200, 10)
cord(X)
}
\keyword{cluster}
\keyword{multivariate}

