% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingSpecificDose-class}
\alias{StoppingSpecificDose-class}
\alias{.StoppingSpecificDose}
\alias{StoppingSpecificDose}
\alias{.DefaultStoppingSpecificDose}
\title{\code{StoppingSpecificDose}}
\usage{
StoppingSpecificDose(
  rule = StoppingTargetProb(target = c(0, 0.3), prob = 0.8),
  dose = 80,
  report_label = NA_character_
)

.DefaultStoppingSpecificDose()
}
\arguments{
\item{rule}{(\code{Stopping})\cr see slot definition.}

\item{dose}{(\code{number})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA}) \cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{StoppingSpecificDose}} is the class for testing a stopping rule at specific
dose of the dose grid and not at the next best dose.
}
\section{Slots}{

\describe{
\item{\code{rule}}{(\code{Stopping})\cr a stopping rule available in this package.}

\item{\code{dose}}{(\code{positive_number})\cr a dose that is defined as part of the dose
grid of the data.}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingSpecificDose()} function.
}
\examples{
# Stop if highest dose 80 is safe.
highest_dose_safe <- StoppingSpecificDose(
  rule = StoppingTargetProb(target = c(0, 0.3), prob = 0.8),
  dose = 80
)

# Stop if lowest dose 10 is toxic.
lowest_dose_toxic <- StoppingSpecificDose(
  rule = StoppingTargetProb(target = c(0.3, 1), prob = 0.8),
  dose = 10
)
}
