% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_types.R
\name{field_types_available}
\alias{field_types_available}
\alias{ft_timepoint}
\alias{ft_uniqueidentifier}
\alias{ft_categorical}
\alias{ft_numeric}
\alias{ft_datetime}
\alias{ft_freetext}
\alias{ft_simple}
\alias{ft_strata}
\alias{ft_ignore}
\title{Types of data fields available for specification}
\usage{
ft_timepoint(includes_time = TRUE, format = "", na = NULL)

ft_uniqueidentifier(na = NULL)

ft_categorical(aggregate_by_each_category = FALSE, na = NULL)

ft_numeric(na = NULL)

ft_datetime(includes_time = TRUE, format = "", na = NULL)

ft_freetext(na = NULL)

ft_simple(na = NULL)

ft_strata(na = NULL)

ft_ignore()
}
\arguments{
\item{includes_time}{If \code{TRUE}, additional aggregated values will be
generated using the time portion (and if no time portion is present then
midnight will be assumed). If \code{FALSE}, aggregated values will ignore any
time portion. Default = \code{TRUE}}

\item{format}{Where datetime values are not in the format \code{YYYY-MM-DD} or
\verb{YYYY-MM-DD HH:MM:SS}, an alternative format can be specified at the per
field level, using \code{\link[readr:parse_datetime]{readr::col_datetime()}} format specifications, e.g.
\code{format = "\%d/\%m/\%Y"}. When a format is supplied, it must match the
complete string.}

\item{na}{Column-specific vector of strings that should be interpreted as missing
values (in addition to those specified at dataset level)}

\item{aggregate_by_each_category}{If \code{TRUE}, aggregated values will be
generated for each distinct subcategory as well as for the field overall.
If \code{FALSE}, aggregated values will only be generated for the field overall.
Default = \code{FALSE}}
}
\value{
A \code{field_type} object denoting the type of data in the column
}
\description{
Each column in the source dataset must be assigned to a particular \code{ft_xx}
depending on the type of data that it contains. This is done through a
\code{\link[=field_types]{field_types()}} specification.
}
\section{Details}{
 \code{ft_timepoint()} - identifies the data field which should
be used as the independent time variable. There should be one and only one
of these specified.

 \code{ft_uniqueidentifier()} - identifies data fields which
contain a (usually computer-generated) identifier for an entity, e.g. a
patient. It does not need to be unique within the dataset.

 \code{ft_categorical()} - identifies data fields which should
be treated as categorical.


\code{ft_numeric()} - identifies data fields which contain numeric values that
should be treated as continuous. Any values which contain non-numeric
characters (including grouping marks) will be classed as non-conformant

 \code{ft_datetime()} - identifies data fields which contain date
values that should be treated as continuous.

 \code{ft_freetext()} - identifies data fields which contain
free text values. Only presence/missingness will be evaluated.

 \code{ft_simple()} - identifies data fields where you only
want presence/missingness to be evaluated (but which are not necessarily
free text).

 \code{ft_strata()} - identifies a categorical data field which should
be used to stratify the rest of the data.

 \code{ft_ignore()} - identifies data fields which should be
ignored.  These will not be loaded.
}

\examples{
fts <- field_types(
  PatientID = ft_uniqueidentifier(),
  TestID = ft_ignore(),
  TestDate = ft_timepoint(),
  TestName = ft_categorical(aggregate_by_each_category = FALSE),
  TestResult = ft_numeric(),
  ResultDate = ft_datetime(),
  ResultComment = ft_freetext(),
  Location = ft_categorical()
)

ft_simple()
}
\seealso{
\code{\link[=field_types]{field_types()}}, \code{\link[=template_field_types]{template_field_types()}}
}
