% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R
\name{initialize,SystemMetadata-method}
\alias{initialize,SystemMetadata-method}
\alias{SystemMetadata-initialize}
\title{Initialize a DataONE SystemMetadata object with default values or values passed in to the constructor.}
\usage{
\S4method{initialize}{SystemMetadata}(
  .Object,
  identifier = NA_character_,
  formatId = NA_character_,
  size = NA_real_,
  checksum = NA_character_,
  checksumAlgorithm = "SHA-256",
  submitter = NA_character_,
  rightsHolder = NA_character_,
  accessPolicy = data.frame(subject = character(), permission = character()),
  replicationAllowed = TRUE,
  numberReplicas = 3,
  obsoletes = NA_character_,
  obsoletedBy = NA_character_,
  archived = FALSE,
  dateUploaded = NA_character_,
  dateSysMetadataModified = NA_character_,
  originMemberNode = NA_character_,
  authoritativeMemberNode = NA_character_,
  preferredNodes = list(),
  blockedNodes = list(),
  seriesId = NA_character_,
  mediaType = NA_character_,
  fileName = NA_character_,
  mediaTypeProperty = list()
)
}
\arguments{
\item{.Object}{The object being initialized}

\item{identifier}{value of type \code{"character"}, the identifier of the object that this system metadata describes.}

\item{formatId}{value of type \code{"character"}, the DataONE object format for the object.}

\item{size}{value of type \code{"numeric"}, the size of the object in bytes.}

\item{checksum}{value of type \code{"character"}, the checksum for the object using the designated checksum algorithm.}

\item{checksumAlgorithm}{value of type \code{"character"}, the name of the hash function used to generate a checksum, from the DataONE controlled list.}

\item{submitter}{value of type \code{"character"}, the Distinguished Name or identifier of the person submitting the object.}

\item{rightsHolder}{value of type \code{"character"}, the Distinguished Name or identifier of the person who holds access rights to the object.}

\item{accessPolicy}{value of type \code{"data.frame"} containing (subject, permission) tuples to constitute the access authorization rules.}

\item{replicationAllowed}{value of type \code{"logical"}, for replication policy allows replicas.}

\item{numberReplicas}{value of type \code{"numeric"}, for number of supported replicas.}

\item{obsoletes}{value of type \code{"character"}, the identifier of an object which this object replaces.}

\item{obsoletedBy}{value of type \code{"character"}, the identifier of an object that replaces this object.}

\item{archived}{value of type \code{"logical"}, a boolean flag indicating whether the object has been archived and thus hidden.}

\item{dateUploaded}{value of type \code{"character"}, the date on which the object was uploaded to a member node.}

\item{dateSysMetadataModified}{value of type \code{"character"}, the last date on which this system metadata was modified.}

\item{originMemberNode}{value of type \code{"character"}, the node identifier of the node on which the object was originally registered.}

\item{authoritativeMemberNode}{value of type \code{"character"}, the node identifier of the node which currently is authoritative for the object.}

\item{preferredNodes}{list of \code{"character"}, each of which is the node identifier for a node to which a replica should be sent.}

\item{blockedNodes}{list of \code{"character"}, each of which is the node identifier for a node blocked from housing replicas.}

\item{seriesId}{value of type \code{"character"}, a unique Unicode string that identifies an object revision chain. A seriesId will resolve to the latest version of an object.}

\item{mediaType}{value of type \code{"character"}, the IANA Media Type (aka MIME-Type) of the object, e.g. "text/csv".}

\item{fileName}{value of type \code{"character"}, the name of the file to create when this object is downloaded from DataONE.}

\item{mediaTypeProperty}{value of type a \code{"list"} of \code{"character"}, IANA Media Type properties for the \code{"mediaType"} argument}
}
\value{
the SystemMetadata instance representing an object
}
\description{
Initialize a SystemMetadata object by providing default values for core information 
needed to manage objects across repository systems. SystemMetadata contains basic identification, ownership,
access policy, replication policy, and related metadata.
}
\seealso{
\url{https://releases.dataone.org/online/api-documentation-v2.0/apis/Types.html}

\code{\link{SystemMetadata-class}}
}
