% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_qgo.R
\name{model_qgo}
\alias{model_qgo}
\title{Quadratically Constrained CRS Generalized Oriented DEA model.}
\usage{
model_qgo(datadea,
            dmu_eval = NULL,
            dmu_ref = NULL,
            d_input = 1,
            d_output = 1,
            rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
            L = 1,
            U = 1,
            give_X = TRUE,
            maxslack = TRUE,
            weight_slack_i = 1,
            weight_slack_o = 1,
            returnqp = FALSE,
            ...)
}
\arguments{
\item{datadea}{A \code{deadata} object with \code{n} DMUs, \code{m} inputs and \code{s}
outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation
reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{d_input}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the input orientation parameters.
If \code{d_input} == 1 (default) and \code{d_output} == 0, it is equivalent
to input oriented.}

\item{d_output}{A value, vector of length \code{s}, or matrix \code{s} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the output orientation parameters.
If \code{d_input} == 0 and \code{d_output} == 1 (default), it is equivalent
to output oriented.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{give_X}{Logical. If it is \code{TRUE}, it uses an initial vector (given by
the evaluated DMU) for the solver, except for "cccp". If it is \code{FALSE}, the initial vector is given
internally by the solver and it is usually randomly generated.}

\item{maxslack}{Logical. If it is \code{TRUE}, it computes the max slack solution.}

\item{weight_slack_i}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the weights of the input slacks
for the max slack solution.}

\item{weight_slack_o}{A value, vector of length \code{s}, or matrix \code{s} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the weights of the output
slacks for the max slack solution.}

\item{returnqp}{Logical. If it is \code{TRUE}, it returns the quadratic problems
(objective function and constraints) of stage 1.}

\item{...}{Other parameters, like the initial vector \code{X}, to be passed to the solver.}
}
\value{
A list of class \code{dea} with the results for the evaluated DMUs (\code{DMU} component,
we note that we call "targets" to the "efficient projections"
in the strongly efficient frontier),
 along with any other necessary information to replicate the results, such as
 the name of the model and parameters \code{d_input}, \code{d_output}, \code{rts},
 \code{dmu_eval} and \code{dmu_ref}.
}
\description{
It solves quadratically constrained CRS generalized oriented DEA
models, using alabama solver. By default, models are solved in a two-stage
process (slacks are maximized).
}
\examples{

data("PFT1981") 
# Selecting DMUs in Program Follow Through (PFT)
PFT <- PFT1981[1:49, ] 
PFT <- make_deadata(PFT,
                    inputs = 2:6, 
                    outputs = 7:9 )
eval_pft <- model_qgo(PFT, dmu_eval = 1:5)
efficiencies(eval_pft)

}
\references{
"A new family of models with generalized orientation in data envelopment
analysis". V. J. Bolós, R. Benítez, V. Coll-Serrano. International
Transactions in Operational Research. \doi{10.1111/itor.70063}
}
\seealso{
\code{\link{model_basic}}, \code{\link{model_dir}}, \code{\link{model_lgo}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
