% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{G.box}
\alias{G.box}
\title{Family of box functions}
\usage{
G.box(
  x,
  g.idx,
  data,
  n.box.per.cov,
  norm.func,
  cov.ranges = NULL,
  norm.cov.out = NULL,
  ...
)
}
\arguments{
\item{x}{Vector of covariates to be normalized alongside the data. Default is
\code{x = NULL}.}

\item{g.idx}{Index of the instrumental function, in \{1, ..., n.inst.func\}.}

\item{data}{Data frame.}

\item{n.box.per.cov}{Number of box functions to consider per continuous
covariate.}

\item{norm.func}{Function to be used to normalize the covariates.}

\item{cov.ranges}{Matrix of ranges of the covariates. Used for normalizing
the data to the unit interval before applying the instrumental functions.
Default is \code{cov.ranges = NULL}.}

\item{norm.cov.out}{Output of a preliminary call to the supplied covariate
normalization function.}

\item{...}{Additional arguments will be ignored. Useful for allowing
compatibility with the implementations of other instrument function families.
Specifically, it allows to ignore the \code{degree} argument used in
'G.spline.R' and 'G.cd.R'.}
}
\description{
This function defined the class of box functions as defined in
Willems et al. (2024+).
}
