% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{datatable}
\alias{datatable}
\alias{datatable.default}
\alias{datatable.desctable}
\title{Create an HTML table widget using the DataTables library}
\usage{
datatable(data, ...)

\method{datatable}{default}(
  data,
  options = list(),
  class = "display",
  callback = DT::JS("return table;"),
  caption = NULL,
  filter = c("none", "bottom", "top"),
  escape = TRUE,
  style = "default",
  width = NULL,
  height = NULL,
  elementId = NULL,
  fillContainer = getOption("DT.fillContainer", NULL),
  autoHideNavigation = getOption("DT.autoHideNavigation", NULL),
  selection = c("multiple", "single", "none"),
  extensions = list(),
  plugins = NULL,
  ...
)

\method{datatable}{desctable}(
  data,
  options = list(paging = F, info = F, search = list(), dom = "Brtip", fixedColumns =
    T, fixedHeader = T, buttons = c("copy", "excel")),
  class = "display",
  callback = DT::JS("return table;"),
  caption = NULL,
  filter = c("none", "bottom", "top"),
  escape = FALSE,
  style = "default",
  width = NULL,
  height = NULL,
  elementId = NULL,
  fillContainer = getOption("DT.fillContainer", NULL),
  autoHideNavigation = getOption("DT.autoHideNavigation", NULL),
  selection = c("multiple", "single", "none"),
  extensions = c("FixedHeader", "FixedColumns", "Buttons"),
  plugins = NULL,
  rownames = F,
  digits = 2,
  ...
)
}
\arguments{
\item{data}{a data object (either a matrix or a data frame)}

\item{...}{arguments passed to \code{format}.}

\item{options}{a list of initialization options (see
\url{https://datatables.net/reference/option/}); the character options
wrapped in \code{\link[htmlwidgets]{JS}()} will be treated as literal
JavaScript code instead of normal character strings; you can also set
options globally via \code{\link{options}(DT.options = list(...))}, and
global options will be merged into this \code{options} argument if set}

\item{class}{the CSS class(es) of the table; see
\url{https://datatables.net/manual/styling/classes}}

\item{callback}{the body of a JavaScript callback function with the argument
\code{table} to be applied to the DataTables instance (i.e. \code{table})}

\item{caption}{the table caption; a character vector or a tag object
generated from \code{htmltools::tags$caption()}}

\item{filter}{whether/where to use column filters; \code{none}: no filters;
\code{bottom/top}: put column filters at the bottom/top of the table; range
sliders are used to filter numeric/date/time columns, select lists are used
for factor columns, and text input boxes are used for character columns; if
you want more control over the styles of filters, you can provide a list to
this argument of the form \code{list(position = 'top', clear = TRUE, plain
= FALSE)}, where \code{clear} indicates whether you want the clear buttons
in the input boxes, and \code{plain} means if you want to use Bootstrap
form styles or plain text input styles for the text input boxes}

\item{escape}{whether to escape HTML entities in the table: \code{TRUE} means
to escape the whole table, and \code{FALSE} means not to escape it;
alternatively, you can specify numeric column indices or column names to
indicate which columns to escape, e.g. \code{1:5} (the first 5 columns),
\code{c(1, 3, 4)}, or \code{c(-1, -3)} (all columns except the first and
third), or \code{c('Species', 'Sepal.Length')}; since the row names take
the first column to display, you should add the numeric column indices by
one when using \code{rownames}}

\item{style}{either \code{'auto'}, \code{'default'}, \code{'bootstrap'}, or
\code{'bootstrap4'}. If \code{'auto'}, and a **bslib** theme is
currently active, then bootstrap styling is used in a way that "just works"
for the active theme. Otherwise,
\href{https://datatables.net/manual/styling/classes}{DataTables
\code{'default'} styling} is used. If set explicitly to \code{'bootstrap'}
or \code{'bootstrap4'}, one must take care to ensure Bootstrap's HTML
dependencies (as well as Bootswatch themes, if desired) are included on the
page. Note, when set explicitly, it's the user's responsibility to ensure
that only one unique `style` value is used on the same page, if multiple
DT tables exist, as different styling resources may conflict with each other.}

\item{width}{Width/Height in pixels (optional, defaults to automatic
sizing)}

\item{height}{Width/Height in pixels (optional, defaults to automatic
sizing)}

\item{elementId}{An id for the widget (a random string by default).}

\item{fillContainer}{\code{TRUE} to configure the table to automatically fill
it's containing element. If the table can't fit fully into it's container
then vertical and/or horizontal scrolling of the table cells will occur.}

\item{autoHideNavigation}{\code{TRUE} to automatically hide navigational UI
(only display the table body) when the number of total records is less
than the page size. Note, it only works on the client-side processing mode
and the `pageLength` option should be provided explicitly.}

\item{selection}{the row/column selection mode (single or multiple selection
or disable selection) when a table widget is rendered in a Shiny app;
alternatively, you can use a list of the form \code{list(mode = 'multiple',
selected = c(1, 3, 8), target = 'row', selectable = c(-2, -3))} to
pre-select rows and control the selectable range; the element
\code{target} in the list can be \code{'column'} to enable column
selection, or \code{'row+column'} to make it possible to select both rows
and columns (click on the footer to select columns), or \code{'cell'} to
select cells. See details section for more info.}

\item{extensions}{a character vector of the names of the DataTables
extensions (\url{https://datatables.net/extensions/index})}

\item{plugins}{a character vector of the names of DataTables plug-ins
(\url{https://rstudio.github.io/DT/plugins.html}).  Note that only those
plugins supported by the \code{DT} package can be used here. You can see
the available plugins by calling \code{DT:::available_plugins()}}

\item{rownames}{\code{TRUE} (show row names) or \code{FALSE} (hide row names)
or a character vector of row names; by default, the row names are displayed
in the first column of the table if exist (not \code{NULL})}

\item{digits}{the desired number of digits after the decimal
    point (\code{format = "f"}) or \emph{significant} digits
    (\code{format = "g"}, \code{= "e"} or \code{= "fg"}).

    Default: 2 for integer, 4 for real numbers.  If less than 0,
    the C default of 6 digits is used.  If specified as more than 50, 50
    will be used with a warning unless \code{format = "f"} where it is
    limited to typically 324. (Not more than 15--21 digits need be
    accurate, depending on the OS and compiler used.  This limit is
    just a precaution against segfaults in the underlying C runtime.)
  }
}
\description{
This function creates an HTML widget to display rectangular data (a matrix or data frame) using the JavaScript library DataTables, with a method for \code{desctable} objects.
}
\note{
You are recommended to escape the table content for security reasons (e.g. XSS attacks) when using this function in Shiny or any other dynamic web applications.
}
\examples{
library(DT)

# see the package vignette for examples and the link to website
vignette('DT', package = 'DT')

# some boring edge cases for testing purposes
m = matrix(nrow = 0, ncol = 5, dimnames = list(NULL, letters[1:5]))
datatable(m)  # zero rows
datatable(as.data.frame(m))

m = matrix(1, dimnames = list(NULL, 'a'))
datatable(m)  # one row and one column
datatable(as.data.frame(m))

m = data.frame(a = 1, b = 2, c = 3)
datatable(m)
datatable(as.matrix(m))

# dates
datatable(data.frame(
  date = seq(as.Date("2015-01-01"), by = "day", length.out = 5), x = 1:5
))
datatable(data.frame(x = Sys.Date()))
datatable(data.frame(x = Sys.time()))

###
}
\references{
See \url{https://rstudio.github.io/DT/} for the full documentation.
}
\keyword{deprecated}
