% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble-vctrs.R
\name{vec_proxy.distribution}
\alias{vec_proxy.distribution}
\alias{vec_restore.distribution}
\title{Methods for including distributions as vctrs in tibbles}
\usage{
vec_proxy.distribution(x, ...)

vec_restore.distribution(x, to, ...)
}
\arguments{
\item{x, to}{Objects inheriting from \code{distribution}.}

\item{...}{Currently not used.}
}
\value{
The \code{vec_proxy} method returns a \code{distribution} object which
additionally inherits of \code{data.frame} while the \code{vec_restore} method
restores the original \code{distribution} classes.
}
\description{
Methods for \code{\link[vctrs]{vec_proxy}} and \code{\link[vctrs]{vec_restore}}
from \pkg{vctrs} in order to include \code{distribution} objects in
\code{\link[tibble]{tibble}} objects.
}
\details{
The methods for \code{\link[vctrs]{vec_proxy}} and
\code{\link[vctrs]{vec_restore}} from \pkg{vctrs} are needed so that
\code{distribution} objects can be included as a vector column in
(and extracted from) \code{\link[tibble]{tibble}} data frames.
\code{vec_proxy} simply adds the class \code{data.frame} which is the
actual underlying data structure used by \code{distribution} objects.
This way the number of rows etc. can be correctly determined. Conversely,
\code{vec_restore} strips off the additional \code{data.frame} class and
restores the original \code{distribution} classes. Users typically do not
need to call \code{vec_proxy} and \code{vec_restore} directly.
}
\examples{
\dontshow{ if(!requireNamespace("tibble")) {
  if(interactive() || is.na(Sys.getenv("_R_CHECK_PACKAGE_NAME_", NA))) {
    stop("not all packages required for the example are installed")
  } else q() }
}
## Poisson GLM for FIFA 2018 goals data
data("FIFA2018", package = "distributions3")
m <- glm(goals ~ difference, data = FIFA2018, family = poisson)

## Predict fitted Poisson distributions for teams with ability differences
## of -1, 0, 1 (out-of-sample) using the new data as a data.frame
nd <- data.frame(difference = -1:1)
nd$dist <- prodist(m, newdata = nd)
nd

## Do the same using the new data as a tibble
library("tibble")
nt <- tibble(difference = -1:1)
nt$dist <- prodist(m, newdata = nt)
nt

}
\keyword{internal}
