% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm.R
\name{decision_10}
\alias{decision_10}
\title{Decision 10: close small gaps between successive prescriptions}
\usage{
decision_10(data, decision = "a")
}
\arguments{
\item{data}{a data frame}

\item{decision}{one of the following strings:
\describe{
\item{"a"}{do nothing}
\item{"b_15"}{change stop date of first prescription to start date of next if gap is \eqn{\leq 15} days}
\item{"b_30"}{change stop date of first prescription to start date of next if gap is \eqn{\leq 30} days}
\item{"b_60"}{change stop date of first prescription to start date of next if gap is \eqn{\leq 60} days}
}}
}
\description{
Where one prescription (for the same drug and patient) starts only a short
time after the previous finishes, this function can close the gap, as if
the prescription was continuous over the entire period.
}
\details{
The underlying function is called \code{close_small_gaps}
}
\seealso{
Other decision functions: 
\code{\link{decision_1}()},
\code{\link{decision_2}()},
\code{\link{decision_3}()},
\code{\link{decision_4}()},
\code{\link{decision_5}()},
\code{\link{decision_6}()},
\code{\link{decision_7}()},
\code{\link{decision_8}()},
\code{\link{decision_9}()},
\code{\link{drug_prep}()}
}
\concept{decision functions}
