% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictRTConfModels.R
\name{predictRTConfModels}
\alias{predictRTConfModels}
\alias{predictConfModels}
\alias{predictRTModels}
\title{Prediction of confidence and RT distributions for several sequential
sampling confidence models and parameter constellations in parallel}
\usage{
predictConfModels(paramDf, maxrt = 15, subdivisions = 100L,
  simult_conf = FALSE, stop.on.error = FALSE, .progress = TRUE,
  parallel = FALSE, n.cores = NULL)

predictRTModels(paramDf, maxrt = 9, subdivisions = 100L, minrt = NULL,
  simult_conf = FALSE, scaled = FALSE, DistConf = NULL,
  .progress = TRUE, parallel = FALSE, n.cores = NULL)
}
\arguments{
\item{paramDf}{a dataframe with one row per combination of model and
participant/parameter set. Columns may include a \code{participant} (\code{sbj}, or
\code{subject}) column, and must include a \code{model} column and the names of the model parameters.
For different stimulus
quality/mean drift rates, names should be \code{v1}, \code{v2}, \code{v3},.... Different \code{s} parameters
are possible with \code{s1}, \code{s2}, \code{s3}... with equally many steps as for drift rates (same
for \code{sv} parameter in dynWEV and 2DSD).
Additionally, the confidence thresholds should be given by names with
\code{thetaUpper1}, \code{thetaUpper2},..., \code{thetaLower1},... or,
for symmetric thresholds only by \code{theta1}, \code{theta2},....}

\item{maxrt}{numeric. The maximum RT for the
integration/density computation. Default: 15 (for \code{predictConfModels} (integration)) and
9 (for \code{predictRTModels}).}

\item{subdivisions}{\code{integer} (default: 100).
For \code{predictConfModels} it is used as argument for the inner integral routine.
For \code{predictRTModels} it is the number of points for which the density is computed.}

\item{simult_conf}{logical, only relevant for dynWEV and 2DSD. Whether in the experiment
confidence was reported simultaneously with the decision, as then decision and confidence
judgment are assumed to have happened subsequent before response and computations are
different, when there is an observable interjudgment time (then \code{simult_conf} should be FALSE).}

\item{stop.on.error}{logical. Argument directly passed on to integrate. Default is FALSE,
since the densities invoked may lead to slow convergence of the integrals (which are still
quite accurate) which causes R to throw an error.}

\item{.progress}{logical. If TRUE (default) a progress bar is drawn to the console. (Works
for some OS only when \code{parallel=FALSE}.)}

\item{parallel}{logical. If TRUE, prediction is parallelized over participants and models
(i.e. over the calls for the respective \code{\link{predictRTConf}} functions).}

\item{n.cores}{integer. If \code{parallel} is TRUE, the number of cores used for
parallelization is required. If \code{NULL} (default) the number of available cores -1 is used.}

\item{minrt}{numeric or \code{NULL}(default). The minimum rt for the density computation.
If \code{NULL}, the minimal possible response time possible with given parameters will be used (min(t0)).}

\item{scaled}{logical. Whether the computed density
should be scaled to integrate to one (additional column \code{densscaled}). Otherwise the output
contains only the defective density (i.e. its integral is equal to the probability of a
response and not 1). If \code{TRUE}, the argument \code{DistConf} should be given, if available.
Default: \code{FALSE}.}

\item{DistConf}{\code{NULL} or \code{data.frame}. A \code{data.frame} with participant
and model columns and columns, giving the distribution of response and rating choices for
different conditions and stimulus categories in the form of the output of
\code{predictConfModels}. It is only necessary if \code{scaled=TRUE}, because these
probabilities are used for scaling. If \code{scaled=TRUE} and \code{DistConf=NULL}, it will be computed
with the function \code{predictConfModels}, which takes some time and the function will
throw a message. Default: \code{NULL}}
}
\value{
\code{predictConfModels} returns a \code{data.frame}/\code{tibble} with columns: \code{participant} (or \code{sbj},
subject depending on the input), \code{model}, \code{condition}, \code{stimulus},
\code{response}, \code{rating}, \code{correct}, \code{p}, \code{info}, \code{err}. \code{p} is the predicted probability of a response
and \code{rating}, given the stimulus category and condition. \code{info} and \code{err} refer to the
respective outputs of the integration routine used for the computation.
\code{predictRTModels} returns a \code{data.frame}/\code{tibble} with columns: \code{participant} (or \code{sbj}/\code{subject}
depending on the input), \code{model}, \code{condition}, \code{stimulus},
\code{response}, \code{rating}, \code{correct}, \code{rt} and \code{dens} (and \code{densscaled}, if \code{scaled=TRUE}).
}
\description{
This function is a wrapper around the functions \code{\link{predictRTConf}} (see
there for more information). It calls the respective function for predicting the
response distribution (discrete decision and rating outcomes) and the rt density
(density for decision, rating and response time) for every model and
participant/subject combination in \code{paramDf}.
Also, see \code{\link{ddynaViTE}}, \code{\link{d2DSD}}, and \code{\link{dRM}} for more
information about the parameters.
}
\details{
These functions merely split the input data frame by model participants combinations,
call the equivalent \code{\link{predictRTConf}} functions for the individual parameter sets
and bind the outputs together. They are included for convenience and the easy parallelization,
which facilitates speeding up computations considerably. For the argument
\code{paramDf}, the output of the fitting function \code{\link{fitRTConfModels}} with the
respective models and participants may be used.

The function \code{\link{predictConf}} (called by \code{predictConfModels})
consists merely of an integration of the reaction time density or the given model,
\code{{d*model*}}, over the reaction time in a reasonable interval (0 to \code{maxrt}).
The function \code{\link{predictRT}} (called by \code{predictRTModels}) wraps these
density functions to a parameter set input and a data.frame output. '
Note, that the encoding for stimulus identity is different between diffusion based models
(2DSD, dynWEV) and race models (IRM(t), PCRM(t)). Therefore, in the columns stimulus and
response there will be a mix of encodings: -1/1 for diffusion based models and 1/2 for
race models. This, usually is not important, since for further aggregation models will
not be mixed.
}
\note{
Different parameters for different conditions are only allowed for drift rate
\code{v}, drift rate variability \code{sv} (only dynWEV and 2DSD), and process variability
\code{s}. All other parameters are used for all conditions.
}
\examples{
# First example for 2 participant and the "dynWEV" model
# (equivalent applicable for
# all other models (with different parameters!))
# 1. Define two parameter sets from different participants
paramDf <- data.frame(participant = c(1,2), model="dynWEV",
                      a=c(1.5, 2),v1=c(0.2,0.1), v2=c(1, 1.5),
                      t0=c(0.1, 0.2),z=c(0.52,0.45),
                      sz=c(0.0,0.3),sv=c(0.4,0.7), st0=c(0,0.01),
                      tau=c(2,3), w=c(0.5,0.2),
                      theta1=c(1,1.5), svis=c(0.5,0.1), sigvis=c(0.8, 1.2))
paramDf
# 2. Predict discrete Choice x Confidence distribution:
# model is not an extra argument but must be a column of paramDf
preds_Conf <- predictConfModels(paramDf, maxrt = 15, simult_conf=TRUE,
                                .progress=TRUE, parallel = FALSE)
# 3. Compute RT density
preds_RT <- predictRTModels(paramDf, maxrt=6, subdivisions=100,
                      scaled=TRUE, DistConf = preds_Conf,
                      parallel=FALSE, .progress = TRUE)
head(preds_RT)
\donttest{
  # produces a warning, if scaled=TRUE and DistConf missing
  preds_RT <- predictRTModels(paramDf, scaled=TRUE)
}
# Use PDFtoQuantiles to get predicted RT quantiles
head(PDFtoQuantiles(preds_RT, scaled = FALSE))

# Second Example: only one parameter set but for two different models
\donttest{
  paramDf1 <- data.frame(model="dynWEV", a=1.5,v1=0.2, v2=1, t0=0.1,z=0.52,
                        sz=0.3,sv=0.4, st0=0,  tau=3, w=0.5,
                        theta1=1, svis=0.5, sigvis=0.8)
  paramDf2 <- data.frame(model="PCRMt", a=2,b=2, v1=0.5, v2=1, t0=0.1,st0=0,
                        wx=0.6, wint=0.2, wrt=0.2, theta1=4)
  paramDf <- dplyr::full_join(paramDf1, paramDf2)
  paramDf  # each model parameters sets hat its relevant parameters
  predictConfModels(paramDf, parallel=FALSE, .progress=TRUE)
}

}
\author{
Sebastian Hellmann.
}
