% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvial_model_response.R
\name{tidy_imp}
\alias{tidy_imp}
\title{tidy up dataframe containing model feature importance}
\usage{
tidy_imp(imp, df, .f = max, resp_var = NULL)
}
\arguments{
\item{imp}{dataframe or matrix with feature importance information}

\item{df}{dataframe, modeling training data}

\item{.f}{window function, Default: max}

\item{resp_var}{character, prediction variable, can usually be inferred from 
imp and df. It does not work for all models and needs to be specified in those 
cases.}
}
\value{
dataframe \describe{ \item{vars}{character column with feature names}
  \item{imp}{numerical column, importance values} }
}
\description{
returns dataframe with exactly two columns, vars and imp and
  aggregates dummy encoded variables. Helper function called by all functions
  that take an imp parameter. Can be called manually if formula for
  aggregating dummy encoded variables must be modified.
}
\examples{
# randomforest
df = mtcars2[, ! names(mtcars2) \%in\% 'ids' ]
m = randomForest::randomForest( disp ~ ., df)
imp = m$importance
tidy_imp(imp, df)

}
