% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{s_response_mars}
\alias{s_response_mars}
\title{Generate True Response vector for Non-Linear Simulation}
\usage{
s_response_mars(n, n0, p, genes, beta, binary_outcome = FALSE, E,
  signal_to_noise_ratio = 1, truemodule, nActive)
}
\arguments{
\item{n}{total number of subjects}

\item{n0}{total number of subjects with E=0}

\item{p}{number of genes in design matrix}

\item{genes}{nxp matrix of the genes or covariates}

\item{beta}{true beta coefficient vector}

\item{binary_outcome}{Logical. Should a binary outcome be generated. Default
is \code{FALSE}. See details on how a binary outcome is generated}

\item{E}{binary 0,1, vector of the exposure/environment variable}

\item{signal_to_noise_ratio}{signal to noise ratio, default is 1}

\item{truemodule}{numeric vector of the true module membership used in the
\code{s_response_mars} function. Modules 3 and 4 are active in the
response. See \code{s_response_mars} function for details.}

\item{nActive}{number of active genes in the response used in the
\code{s_response_mars}}
}
\value{
a data.frame/data.table containing the response and the design
  matrix. Also an object of class \code{expression}
}
\description{
Given the covariates and environment variable this function
generates the nonlinear response with specified signal to noise ratio.
}
\note{
See Bhatnagar et al (2017+) for details on how the response is simulated.
}
\examples{
library(magrittr)

# simulation parameters
rho = 0.90; p = 500 ;SNR = 1 ; n = 200; n0 = n1 = 100 ; nActive = p*0.10 ; cluster_distance = "tom";
Ecluster_distance = "difftom"; rhoOther = 0.6; betaMean = 2;
alphaMean = 1; betaE = 3; distanceMethod = "euclidean"; clustMethod = "hclust";
cutMethod = "dynamic"; agglomerationMethod = "average"

#in this simulation its blocks 3 and 4 that are important
#leaveOut:  optional specification of modules that should be left out
#of the simulation, that is their genes will be simulated as unrelated
#("grey"). This can be useful when simulating several sets, in some which a module
#is present while in others it is absent.
d0 <- s_modules(n = n0, p = p, rho = 0, exposed = FALSE,
                modProportions = c(0.15,0.15,0.15,0.15,0.15,0.25),
                minCor = 0.01,
                maxCor = 1,
                corPower = 1,
                propNegativeCor = 0.3,
                backgroundNoise = 0.5,
                signed = FALSE,
                leaveOut = 1:4)

d1 <- s_modules(n = n1, p = p, rho = rho, exposed = TRUE,
                modProportions = c(0.15,0.15,0.15,0.15,0.15,0.25),
                minCor = 0.4,
                maxCor = 1,
                corPower = 0.3,
                propNegativeCor = 0.3,
                backgroundNoise = 0.5,
                signed = FALSE)

truemodule1 <- d1$setLabels

X <- rbind(d0$datExpr, d1$datExpr) \%>\%
  magrittr::set_colnames(paste0("Gene", 1:p)) \%>\%
  magrittr::set_rownames(paste0("Subject",1:n))

betaMainEffect <- vector("double", length = p)

# the first nActive/2 in the 3rd block are active
betaMainEffect[which(truemodule1 \%in\% 3)[1:(nActive/2)]] <- runif(
  nActive/2, betaMean - 0.1, betaMean + 0.1)

# the first nActive/2 in the 4th block are active
betaMainEffect[which(truemodule1 \%in\% 4)[1:(nActive/2)]] <- runif(
  nActive/2, betaMean+2 - 0.1, betaMean+2 + 0.1)
beta <- c(betaMainEffect, betaE)

result <- s_response_mars(n = n, n0 = n0,
                          p = p, genes = X, binary_outcome = TRUE,
                          E = c(rep(0,n0), rep(1, n1)), signal_to_noise_ratio = 1,
                          truemodule = truemodule1, nActive = nActive,
                          beta = beta)
result[1:5,1:5]
}

