% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-claude.R
\name{chat_anthropic}
\alias{chat_anthropic}
\alias{models_anthropic}
\title{Chat with an Anthropic Claude model}
\usage{
chat_anthropic(
  system_prompt = NULL,
  params = NULL,
  max_tokens = deprecated(),
  model = NULL,
  api_args = list(),
  base_url = "https://api.anthropic.com/v1",
  beta_headers = character(),
  api_key = anthropic_key(),
  echo = NULL
)

models_anthropic(
  base_url = "https://api.anthropic.com/v1",
  api_key = anthropic_key()
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{max_tokens}{Maximum number of tokens to generate before stopping.}

\item{model}{The model to use for the chat (defaults to "claude-sonnet-4-20250514").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.
Use \code{models_anthropic()} to see all options.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{beta_headers}{Optionally, a character vector of beta headers to opt-in
claude features that are still in beta.}

\item{api_key}{API key to use for authentication.

You generally should not supply this directly, but instead set the \code{ANTHROPIC_API_KEY} environment variable.
The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://www.anthropic.com}{Anthropic} provides a number of chat based
models under the \href{https://www.anthropic.com/claude}{Claude} moniker.
Note that a Claude Pro membership does not give you the ability to call
models via the API; instead, you will need to sign up (and pay for) a
\href{https://console.anthropic.com/}{developer account}.
}
\examples{
\dontshow{if (has_credentials("claude")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_anthropic()
chat$chat("Tell me three jokes about statisticians")
\dontshow{\}) # examplesIf}
}
\seealso{
Other chatbots: 
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
