% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hspec.R
\docType{class}
\name{hspec-class}
\alias{hspec-class}
\title{An S4 class to represent an exponential marked Hawkes model}
\description{
This class represents a specification of a marked Hawkes model with exponential kernel.
The intensity of the ground process is defined by:
\deqn{\lambda(t) = \mu + \int_{(-\infty,t)\times E} ( \alpha + g(u, z) )  e^{-\beta (t-u)} M(du \times dz).}
For more details, please see the vignettes.
}
\details{
\eqn{\mu} is base intensity.
This is generally a constant vector but can be extended to stochastic processes.
Currently, piecewise constant mu is also possible. mu is left continuous.

\eqn{\alpha} is a constant matrix which represents impacts on intensities after events.
It is represented by slot \code{alpha}.

\eqn{g} is for non-constant parts of the impact.
It may depend on any information generated by \eqn{N}, \eqn{\lambda}, \eqn{z} and so on.
It is represented by slot \code{impact}.

\eqn{\beta} is a constant matrix for exponential decay rates.
It is represented by slot \code{beta}.

\eqn{z} is mark and represented by slot \code{rmark}.

\code{mu}, \code{alpha} and \code{beta} are required slots for every exponential Hawkes model.
\code{rmark} and \code{impact} are additional slots.
}
\section{Slots}{

\describe{
\item{\code{mu}}{Numeric value or matrix or function, if numeric, automatically converted to matrix.}

\item{\code{alpha}}{Numeric value or matrix or function, if numeric, automatically converted to matrix, exciting term.}

\item{\code{beta}}{Numeric value or matrix or function, if numeric, automatically converted to matrix, exponential decay.}

\item{\code{eta}}{Numeric value or matrix or function, if numeric, automatically converted to matrix, impact by additional mark.}

\item{\code{dimens}}{Dimension of the model.}

\item{\code{rmark}}{A function that generates mark for counting process, for simulation.}

\item{\code{dmark}}{A density function for mark, for estimation.}

\item{\code{impact}}{A function that describe the after impact of mark to lambda whose first argument is always \code{param}.}

\item{\code{type_col_map}}{Mapping between type and column number of kernel used for multi-kernel model.}
}}

\examples{
MU <- matrix(c(0.2), nrow = 2)
ALPHA <- matrix(c(0.75, 0.92, 0.92, 0.75), nrow = 2, byrow=TRUE)
BETA <- matrix(c(2.25, 2.25, 2.25, 2.25), nrow = 2, byrow=TRUE)
mhspec2 <- new("hspec", mu=MU, alpha=ALPHA, beta=BETA)
mhspec2

}
